package com.badoo.reaktive.subject.replay

import com.badoo.reaktive.observable.ObservableObserver
import com.badoo.reaktive.subject.AbstractSubject
import com.badoo.reaktive.subject.LinkedQueue
import com.badoo.reaktive.subject.LinkedQueue.Node
import com.badoo.reaktive.subject.forEachAndGetLast

internal class ReplaySubjectImpl<T>(
    bufferLimit: Int,
) : AbstractSubject<T, Node<T>?>(), ReplaySubject<T> {

    private val buffer: LinkedQueue<T> = LinkedQueue(limit = bufferLimit)

    override fun subscribe(observer: ObservableObserver<T>) {
        val disposable = observer.onSubscribe() ?: return
        val lastNode = buffer.head?.forEachAndGetLast { observer.onNext(it) }
        onSubscribe(observer, disposable, lastNode)
    }

    override fun onAfterSubscribe(observer: ObservableObserver<T>, token: Node<T>?) {
        super.onAfterSubscribe(observer, token)

        token?.next?.forEachAndGetLast {
            observer.onNext(it)
        }
    }

    override fun onBeforeNext(value: T) {
        super.onBeforeNext(value)

        buffer.addLast(value)
    }
}
