/*
 * Decompiled with CFR 0.152.
 */
package com.badoo.reaktive.scheduler;

import com.badoo.reaktive.disposable.CompositeDisposable;
import com.badoo.reaktive.disposable.CompositeDisposableExtKt;
import com.badoo.reaktive.disposable.Disposable;
import com.badoo.reaktive.scheduler.ExecutorServiceStrategy;
import com.badoo.reaktive.scheduler.Scheduler;
import com.badoo.reaktive.utils.HandleSourceErrorKt;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/badoo/reaktive/scheduler/ExecutorServiceScheduler;", "Lcom/badoo/reaktive/scheduler/Scheduler;", "executorServiceStrategy", "Lcom/badoo/reaktive/scheduler/ExecutorServiceStrategy;", "(Lcom/badoo/reaktive/scheduler/ExecutorServiceStrategy;)V", "disposables", "Lcom/badoo/reaktive/disposable/CompositeDisposable;", "destroy", "", "newExecutor", "Lcom/badoo/reaktive/scheduler/Scheduler$Executor;", "ExecutorImpl", "reaktive_release"})
public final class ExecutorServiceScheduler
implements Scheduler {
    @NotNull
    private final ExecutorServiceStrategy executorServiceStrategy;
    @NotNull
    private final CompositeDisposable disposables;

    public ExecutorServiceScheduler(@NotNull ExecutorServiceStrategy executorServiceStrategy) {
        Intrinsics.checkNotNullParameter((Object)executorServiceStrategy, (String)"executorServiceStrategy");
        this.executorServiceStrategy = executorServiceStrategy;
        this.disposables = new CompositeDisposable();
    }

    @Override
    @NotNull
    public Scheduler.Executor newExecutor() {
        return new ExecutorImpl(this.disposables, this.executorServiceStrategy);
    }

    @Override
    public void destroy() {
        this.disposables.dispose();
        this.executorServiceStrategy.destroy();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J*\u0010\u0012\u001a\u0004\u0018\u0001H\u0013\"\u0004\b\u0000\u0010\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u00130\u0015H\u0082\b\u00a2\u0006\u0002\u0010\u0016J\u001e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u001bH\u0016J&\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/badoo/reaktive/scheduler/ExecutorServiceScheduler$ExecutorImpl;", "Lcom/badoo/reaktive/scheduler/Scheduler$Executor;", "disposables", "Lcom/badoo/reaktive/disposable/CompositeDisposable;", "executorServiceStrategy", "Lcom/badoo/reaktive/scheduler/ExecutorServiceStrategy;", "(Lcom/badoo/reaktive/disposable/CompositeDisposable;Lcom/badoo/reaktive/scheduler/ExecutorServiceStrategy;)V", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "isDisposed", "", "()Z", "monitor", "", "taskDisposables", "cancel", "", "dispose", "executeIfNotRecycled", "T", "block", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "submit", "delayMillis", "", "task", "Lkotlin/Function0;", "submitRepeating", "startDelayMillis", "periodMillis", "Companion", "reaktive_release"})
    private static final class ExecutorImpl
    implements Scheduler.Executor {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private final CompositeDisposable disposables;
        @NotNull
        private final ExecutorServiceStrategy executorServiceStrategy;
        @Nullable
        private volatile ScheduledExecutorService executor;
        @NotNull
        private final CompositeDisposable taskDisposables;
        @NotNull
        private final Object monitor;

        public ExecutorImpl(@NotNull CompositeDisposable disposables, @NotNull ExecutorServiceStrategy executorServiceStrategy) {
            Intrinsics.checkNotNullParameter((Object)disposables, (String)"disposables");
            Intrinsics.checkNotNullParameter((Object)executorServiceStrategy, (String)"executorServiceStrategy");
            this.disposables = disposables;
            this.executorServiceStrategy = executorServiceStrategy;
            this.executor = this.executorServiceStrategy.get();
            this.taskDisposables = new CompositeDisposable();
            this.monitor = this.taskDisposables;
            CompositeDisposableExtKt.plusAssign(this.disposables, this);
        }

        @Override
        public boolean isDisposed() {
            return this.executor == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            if (this.executor != null) {
                ScheduledExecutorService executorToRecycle = null;
                Object object = this.monitor;
                synchronized (object) {
                    boolean bl = false;
                    ScheduledExecutorService scheduledExecutorService = this.executor;
                    if (scheduledExecutorService == null) {
                        return;
                    }
                    executorToRecycle = scheduledExecutorService;
                    this.executor = null;
                    Unit unit = Unit.INSTANCE;
                }
                this.taskDisposables.dispose();
                this.executorServiceStrategy.recycle(executorToRecycle);
                CompositeDisposableExtKt.minusAssign(this.disposables, this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void submit(long delayMillis, @NotNull Function0<Unit> task) {
            block7: {
                Disposable disposable;
                ScheduledFuture<?> scheduledFuture;
                ScheduledFuture<?> scheduledFuture2;
                Object object;
                Intrinsics.checkNotNullParameter(task, (String)"task");
                ExecutorImpl this_$iv = this;
                boolean $i$f$executeIfNotRecycled = false;
                if (this_$iv.executor != null) {
                    object = this_$iv.monitor;
                    synchronized (object) {
                        ScheduledFuture<?> scheduledFuture3;
                        boolean bl = false;
                        ScheduledExecutorService scheduledExecutorService = this_$iv.executor;
                        if (scheduledExecutorService != null) {
                            ScheduledExecutorService it = scheduledExecutorService;
                            boolean bl2 = false;
                            scheduledFuture3 = it.schedule(ExecutorImpl.Companion.wrapSchedulerTaskSafe((Function0<Unit>)task), delayMillis, TimeUnit.MILLISECONDS);
                        } else {
                            scheduledFuture3 = null;
                        }
                        ScheduledFuture<?> scheduledFuture4 = scheduledFuture3;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl18 : MonitorExitStatement: MONITOREXIT : var7_6
                        scheduledFuture2 = scheduledFuture4;
                    }
                } else {
                    scheduledFuture2 = scheduledFuture = null;
                }
                if (scheduledFuture == null || (disposable = ExecutorImpl.Companion.toDisposable(scheduledFuture)) == null) break block7;
                Disposable disposable2 = disposable;
                object = this.taskDisposables;
                Disposable p0 = disposable2;
                boolean bl = false;
                ((CompositeDisposable)object).add(p0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void submitRepeating(long startDelayMillis, long periodMillis, @NotNull Function0<Unit> task) {
            block7: {
                Disposable disposable;
                ScheduledFuture<?> scheduledFuture;
                ScheduledFuture<?> scheduledFuture2;
                Object object;
                Intrinsics.checkNotNullParameter(task, (String)"task");
                ExecutorImpl this_$iv = this;
                boolean $i$f$executeIfNotRecycled = false;
                if (this_$iv.executor != null) {
                    object = this_$iv.monitor;
                    synchronized (object) {
                        ScheduledFuture<?> scheduledFuture3;
                        boolean bl = false;
                        ScheduledExecutorService scheduledExecutorService = this_$iv.executor;
                        if (scheduledExecutorService != null) {
                            ScheduledExecutorService it = scheduledExecutorService;
                            boolean bl2 = false;
                            scheduledFuture3 = it.scheduleAtFixedRate(ExecutorImpl.Companion.wrapSchedulerTaskSafe((Function0<Unit>)task), startDelayMillis, periodMillis, TimeUnit.MILLISECONDS);
                        } else {
                            scheduledFuture3 = null;
                        }
                        ScheduledFuture<?> scheduledFuture4 = scheduledFuture3;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl18 : MonitorExitStatement: MONITOREXIT : var9_7
                        scheduledFuture2 = scheduledFuture4;
                    }
                } else {
                    scheduledFuture2 = scheduledFuture = null;
                }
                if (scheduledFuture == null || (disposable = ExecutorImpl.Companion.toDisposable(scheduledFuture)) == null) break block7;
                Disposable disposable2 = disposable;
                object = this.taskDisposables;
                Disposable p0 = disposable2;
                boolean bl = false;
                ((CompositeDisposable)object).add(p0);
            }
        }

        @Override
        public void cancel() {
            this.taskDisposables.clear(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final <T> T executeIfNotRecycled(Function1<? super ScheduledExecutorService, ? extends T> block) {
            Object object;
            boolean $i$f$executeIfNotRecycled = false;
            if (this.executor == null) return null;
            Object object2 = this.monitor;
            synchronized (object2) {
                try {
                    boolean bl = false;
                    ScheduledExecutorService scheduledExecutorService = this.executor;
                    object = scheduledExecutorService != null ? block.invoke((Object)scheduledExecutorService) : null;
                }
                catch (Throwable throwable) {
                    InlineMarker.finallyStart((int)1);
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl13 : MonitorExitStatement: MONITOREXIT : object2
                    InlineMarker.finallyEnd((int)1);
                    throw throwable;
                }
                InlineMarker.finallyStart((int)2);
            }
            InlineMarker.finallyEnd((int)2);
            return (T)object;
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0010\u0010\b\u001a\u00020\t*\u0006\u0012\u0002\b\u00030\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/badoo/reaktive/scheduler/ExecutorServiceScheduler$ExecutorImpl$Companion;", "", "()V", "wrapSchedulerTaskSafe", "Ljava/lang/Runnable;", "task", "Lkotlin/Function0;", "", "toDisposable", "Lcom/badoo/reaktive/disposable/Disposable;", "Ljava/util/concurrent/Future;", "reaktive_release"})
        private static final class Companion {
            private Companion() {
            }

            private final Disposable toDisposable(Future<?> $this$toDisposable) {
                return new Disposable($this$toDisposable){
                    final /* synthetic */ Future<?> $this_toDisposable;
                    {
                        this.$this_toDisposable = $receiver;
                    }

                    public boolean isDisposed() {
                        return this.$this_toDisposable.isDone();
                    }

                    public void dispose() {
                        this.$this_toDisposable.cancel(true);
                    }
                };
            }

            private final Runnable wrapSchedulerTaskSafe(Function0<Unit> task) {
                return () -> Companion.wrapSchedulerTaskSafe$lambda-0(task);
            }

            private static final void wrapSchedulerTaskSafe$lambda-0(Function0 $task) {
                Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
                try {
                    $task.invoke();
                }
                catch (Throwable e) {
                    HandleSourceErrorKt.handleReaktiveError$default(e, null, 2, null);
                }
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

