/*
 * Decompiled with CFR 0.152.
 */
package com.badoo.reaktive.observable;

import com.badoo.reaktive.disposable.Disposable;
import com.badoo.reaktive.disposable.SerialDisposable;
import com.badoo.reaktive.observable.Observable;
import com.badoo.reaktive.observable.ObservableCallbacks;
import com.badoo.reaktive.observable.ObservableObserver;
import com.badoo.reaktive.subject.unicast.UnicastSubject;
import com.badoo.reaktive.subject.unicast.UnicastSubjectBuilderKt;
import com.badoo.reaktive.utils.atomic.AtomicBoolean;
import com.badoo.reaktive.utils.atomic.AtomicInt;
import com.badoo.reaktive.utils.atomic.AtomicLong;
import com.badoo.reaktive.utils.queue.ArrayQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001!B1\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0017\u001a\u00020\u000fH\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0015\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0013\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00150\u0014j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0015`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/badoo/reaktive/observable/UpstreamObserver;", "T", "Lcom/badoo/reaktive/disposable/SerialDisposable;", "Lcom/badoo/reaktive/observable/ObservableObserver;", "count", "", "skip", "activeWindowsCount", "Lcom/badoo/reaktive/utils/atomic/AtomicInt;", "downstream", "Lcom/badoo/reaktive/observable/ObservableCallbacks;", "Lcom/badoo/reaktive/observable/Observable;", "(JJLcom/badoo/reaktive/utils/atomic/AtomicInt;Lcom/badoo/reaktive/observable/ObservableCallbacks;)V", "onWindowTerminate", "Lkotlin/Function0;", "", "skippedCount", "Lcom/badoo/reaktive/utils/atomic/AtomicLong;", "tailWindowValuesCount", "windows", "Lcom/badoo/reaktive/utils/queue/ArrayQueue;", "Lcom/badoo/reaktive/subject/unicast/UnicastSubject;", "Lcom/badoo/reaktive/utils/queue/SharedQueue;", "onComplete", "onError", "error", "", "onNext", "value", "(Ljava/lang/Object;)V", "onSubscribe", "disposable", "Lcom/badoo/reaktive/disposable/Disposable;", "WindowWrapper", "reaktive_release"})
final class UpstreamObserver<T>
extends SerialDisposable
implements ObservableObserver<T> {
    private final long count;
    private final long skip;
    @NotNull
    private final AtomicInt activeWindowsCount;
    @NotNull
    private final ObservableCallbacks<Observable<? extends T>> downstream;
    @NotNull
    private final ArrayQueue<UnicastSubject<T>> windows;
    @NotNull
    private final AtomicLong skippedCount;
    @NotNull
    private final AtomicLong tailWindowValuesCount;
    @NotNull
    private final Function0<Unit> onWindowTerminate;

    public UpstreamObserver(long count, long skip2, @NotNull AtomicInt activeWindowsCount, @NotNull ObservableCallbacks<? super Observable<? extends T>> downstream) {
        Intrinsics.checkNotNullParameter((Object)activeWindowsCount, (String)"activeWindowsCount");
        Intrinsics.checkNotNullParameter(downstream, (String)"downstream");
        this.count = count;
        this.skip = skip2;
        this.activeWindowsCount = activeWindowsCount;
        this.downstream = downstream;
        this.windows = new ArrayQueue();
        this.skippedCount = new AtomicLong(0L, 1, null);
        this.tailWindowValuesCount = new AtomicLong(0L, 1, null);
        this.onWindowTerminate = (Function0)new Function0<Unit>(this){
            final /* synthetic */ UpstreamObserver<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (UpstreamObserver.access$getActiveWindowsCount$p(this.this$0).addAndGet(-1) == 0) {
                    this.this$0.dispose();
                }
            }
        };
    }

    @Override
    public void onSubscribe(@NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.set(disposable);
    }

    @Override
    public void onNext(T value) {
        AtomicBoolean atomicBoolean;
        long skipped = this.skippedCount.getValue();
        AtomicBoolean windowWrapper2 = null;
        if (skipped == 0L) {
            this.activeWindowsCount.addAndGet(1);
            UnicastSubject window2 = UnicastSubjectBuilderKt.UnicastSubject$default(0, this.onWindowTerminate, 1, null);
            windowWrapper2 = new WindowWrapper(window2);
            this.windows.offer(window2);
            this.downstream.onNext((Observable<AtomicBoolean>)windowWrapper2);
        } else {
            windowWrapper2 = null;
        }
        Iterable $this$forEach$iv = this.windows;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UnicastSubject it = (UnicastSubject)element$iv;
            boolean bl = false;
            it.onNext(value);
        }
        this.skippedCount.setValue((skipped + 1L) % this.skip);
        if (this.tailWindowValuesCount.getValue() + 1L == this.count) {
            UnicastSubject<T> unicastSubject = this.windows.poll();
            if (unicastSubject == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            unicastSubject.onComplete();
            this.tailWindowValuesCount.addAndGet(1L - this.skip);
        } else {
            this.tailWindowValuesCount.addAndGet(1L);
        }
        boolean bl = (atomicBoolean = windowWrapper2) != null && (atomicBoolean = atomicBoolean.isSubscribed()) != null ? !atomicBoolean.getValue() : false;
        if (bl) {
            windowWrapper2.getWindow().onComplete();
        }
    }

    @Override
    public void onComplete() {
        Iterable $this$forEach$iv = this.windows;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UnicastSubject it = (UnicastSubject)element$iv;
            boolean bl = false;
            it.onComplete();
        }
        this.downstream.onComplete();
        this.dispose();
    }

    @Override
    public void onError(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Iterable $this$forEach$iv = this.windows;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UnicastSubject it = (UnicastSubject)element$iv;
            boolean bl = false;
            it.onError(error);
        }
        this.downstream.onError(error);
        this.dispose();
    }

    public static final /* synthetic */ AtomicInt access$getActiveWindowsCount$p(UpstreamObserver $this) {
        return $this.activeWindowsCount;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u000eH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\bR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/badoo/reaktive/observable/UpstreamObserver$WindowWrapper;", "T", "Lcom/badoo/reaktive/observable/Observable;", "window", "Lcom/badoo/reaktive/subject/unicast/UnicastSubject;", "(Lcom/badoo/reaktive/subject/unicast/UnicastSubject;)V", "isSubscribed", "Lcom/badoo/reaktive/utils/atomic/AtomicBoolean;", "()Lcom/badoo/reaktive/utils/atomic/AtomicBoolean;", "getWindow", "()Lcom/badoo/reaktive/subject/unicast/UnicastSubject;", "subscribe", "", "observer", "Lcom/badoo/reaktive/observable/ObservableObserver;", "reaktive_release"})
    private static final class WindowWrapper<T>
    implements Observable<T> {
        @NotNull
        private final UnicastSubject<T> window;
        @NotNull
        private final AtomicBoolean isSubscribed;

        public WindowWrapper(@NotNull UnicastSubject<T> window2) {
            Intrinsics.checkNotNullParameter(window2, (String)"window");
            this.window = window2;
            this.isSubscribed = new AtomicBoolean(false, 1, null);
        }

        @NotNull
        public final UnicastSubject<T> getWindow() {
            return this.window;
        }

        @NotNull
        public final AtomicBoolean isSubscribed() {
            return this.isSubscribed;
        }

        @Override
        public void subscribe(@NotNull ObservableObserver<? super T> observer2) {
            Intrinsics.checkNotNullParameter(observer2, (String)"observer");
            this.isSubscribed.setValue(true);
            this.window.subscribe(observer2);
        }
    }
}

