/*
 * Decompiled with CFR 0.152.
 */
package com.badoo.reaktive.utils.queue;

import com.badoo.reaktive.utils.queue.ArrayQueue;
import com.badoo.reaktive.utils.queue.Queue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0006\b\u0000\u0018\u0000 \u001d*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0096\u0002J\u0015\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u000f\u0010\u001c\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0004\u0018\u00018\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/badoo/reaktive/utils/queue/ArrayQueue;", "T", "Lcom/badoo/reaktive/utils/queue/Queue;", "()V", "head", "", "isEmpty", "", "()Z", "isFull", "peek", "getPeek", "()Ljava/lang/Object;", "queue", "", "[Ljava/lang/Object;", "size", "getSize", "()I", "tail", "clear", "", "ensureCapacity", "iterator", "", "offer", "item", "(Ljava/lang/Object;)V", "poll", "Companion", "reaktive_release"})
public final class ArrayQueue<T>
implements Queue<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private T[] queue = com.badoo.reaktive.utils.queue.ArrayQueue$Companion.access$createArray(Companion, 8);
    private int head;
    private int tail;
    private boolean isFull;
    public static final int INITIAL_CAPACITY = 8;

    @Override
    @Nullable
    public T getPeek() {
        return this.queue[this.head];
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail && !this.isFull;
    }

    @Override
    public int getSize() {
        return this.isFull ? this.queue.length : (this.tail >= this.head ? this.tail - this.head : this.queue.length + this.tail - this.head);
    }

    @Override
    public void offer(T item) {
        this.ensureCapacity();
        this.queue[this.tail] = item;
        ArrayQueue arrayQueue = this;
        int n = arrayQueue.tail;
        arrayQueue.tail = n + 1;
        if (this.tail > ArraysKt.getLastIndex((Object[])this.queue)) {
            this.tail = 0;
        }
        if (this.tail == this.head) {
            this.isFull = true;
        }
    }

    @Override
    @Nullable
    public T poll() {
        T value = this.getPeek();
        this.queue[this.head] = null;
        if (this.head != this.tail || this.isFull) {
            ArrayQueue arrayQueue = this;
            int n = arrayQueue.head;
            arrayQueue.head = n + 1;
            this.isFull = false;
            if (this.head > ArraysKt.getLastIndex((Object[])this.queue)) {
                this.head = 0;
            }
        }
        return value;
    }

    @Override
    public void clear() {
        int n = 0;
        int n2 = this.queue.length;
        if (n < n2) {
            do {
                int i = n++;
                this.queue[i] = null;
            } while (n < n2);
        }
        this.head = 0;
        this.tail = 0;
        this.isFull = false;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Iterator<T>(this){
            private int counter;
            private int index;
            private final int lastIndex;
            final /* synthetic */ ArrayQueue<T> this$0;
            {
                this.this$0 = $receiver;
                this.counter = this.this$0.getSize();
                this.index = ArrayQueue.access$getHead$p(this.this$0);
                this.lastIndex = ArraysKt.getLastIndex((Object[])ArrayQueue.access$getQueue$p(this.this$0));
            }

            public boolean hasNext() {
                return this.counter > 0;
            }

            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object item = ArrayQueue.access$getQueue$p(this.this$0)[this.index];
                iterator.1 var2_2 = this;
                int n = var2_2.counter;
                var2_2.counter = n + -1;
                var2_2 = this;
                n = var2_2.index;
                var2_2.index = n + 1;
                if (this.index > this.lastIndex) {
                    this.index = 0;
                }
                return (T)item;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    private final void ensureCapacity() {
        if (!this.isFull) {
            return;
        }
        this.isFull = false;
        Object[] arr = ArrayQueue.Companion.createArray(this.queue.length << 1);
        ArraysKt.copyInto((Object[])this.queue, (Object[])arr, (int)0, (int)this.head, (int)this.queue.length);
        ArraysKt.copyInto((Object[])this.queue, (Object[])arr, (int)(this.queue.length - this.head), (int)0, (int)this.head);
        this.tail = this.queue.length;
        this.head = 0;
        this.queue = arr;
    }

    public static final /* synthetic */ int access$getHead$p(ArrayQueue $this) {
        return $this.head;
    }

    public static final /* synthetic */ Object[] access$getQueue$p(ArrayQueue $this) {
        return $this.queue;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00070\u0006\"\u0004\b\u0001\u0010\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/badoo/reaktive/utils/queue/ArrayQueue$Companion;", "", "()V", "INITIAL_CAPACITY", "", "createArray", "", "T", "size", "(I)[Ljava/lang/Object;", "reaktive_release"})
    public static final class Companion {
        private Companion() {
        }

        private final <T> T[] createArray(int size) {
            return new Object[size];
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

