/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.media.MediaPlayer;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.backends.android.AndroidAudio;
import java.io.IOException;
import java.util.List;

public class AndroidMusic
implements Music,
MediaPlayer.OnCompletionListener {
    private final AndroidAudio audio;
    private MediaPlayer player;
    private boolean isPrepared = true;
    protected boolean wasPlaying = false;
    private float volume = 1.0f;
    protected Music.OnCompletionListener onCompletionListener;

    AndroidMusic(AndroidAudio audio, MediaPlayer player) {
        this.audio = audio;
        this.player = player;
        this.onCompletionListener = null;
        this.player.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.player == null) {
            return;
        }
        try {
            this.player.release();
        }
        catch (Throwable t) {
            Gdx.app.log("AndroidMusic", "error while disposing AndroidMusic instance, non-fatal");
        }
        finally {
            this.player = null;
            this.onCompletionListener = null;
            List<AndroidMusic> list = this.audio.musics;
            synchronized (list) {
                this.audio.musics.remove(this);
            }
        }
    }

    public boolean isLooping() {
        if (this.player == null) {
            return false;
        }
        try {
            return this.player.isLooping();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isPlaying() {
        if (this.player == null) {
            return false;
        }
        try {
            return this.player.isPlaying();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void pause() {
        if (this.player == null) {
            return;
        }
        try {
            if (this.player.isPlaying()) {
                this.player.pause();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.wasPlaying = false;
    }

    public void play() {
        if (this.player == null) {
            return;
        }
        try {
            if (this.player.isPlaying()) {
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            if (!this.isPrepared) {
                this.player.prepare();
                this.isPrepared = true;
            }
            this.player.start();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setLooping(boolean isLooping) {
        if (this.player == null) {
            return;
        }
        this.player.setLooping(isLooping);
    }

    public void setVolume(float volume) {
        if (this.player == null) {
            return;
        }
        this.player.setVolume(volume, volume);
        this.volume = volume;
    }

    public float getVolume() {
        return this.volume;
    }

    public void setPan(float pan, float volume) {
        if (this.player == null) {
            return;
        }
        float leftVolume = volume;
        float rightVolume = volume;
        if (pan < 0.0f) {
            rightVolume *= 1.0f - Math.abs(pan);
        } else if (pan > 0.0f) {
            leftVolume *= 1.0f - Math.abs(pan);
        }
        this.player.setVolume(leftVolume, rightVolume);
        this.volume = volume;
    }

    public void stop() {
        if (this.player == null) {
            return;
        }
        if (this.isPrepared) {
            this.player.seekTo(0);
        }
        this.player.stop();
        this.isPrepared = false;
    }

    public void setPosition(float position) {
        if (this.player == null) {
            return;
        }
        try {
            if (!this.isPrepared) {
                this.player.prepare();
                this.isPrepared = true;
            }
            this.player.seekTo((int)(position * 1000.0f));
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public float getPosition() {
        if (this.player == null) {
            return 0.0f;
        }
        return (float)this.player.getCurrentPosition() / 1000.0f;
    }

    public float getDuration() {
        if (this.player == null) {
            return 0.0f;
        }
        return (float)this.player.getDuration() / 1000.0f;
    }

    public void setOnCompletionListener(Music.OnCompletionListener listener) {
        this.onCompletionListener = listener;
    }

    public void onCompletion(MediaPlayer mp) {
        if (this.onCompletionListener != null) {
            Gdx.app.postRunnable(new Runnable(){

                @Override
                public void run() {
                    AndroidMusic.this.onCompletionListener.onCompletion((Music)AndroidMusic.this);
                }
            });
        }
    }
}

