/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Build;
import android.os.Handler;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.badlogic.gdx.AbstractInput;
import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.backends.android.AndroidApplicationConfiguration;
import com.badlogic.gdx.backends.android.AndroidGraphics;
import com.badlogic.gdx.backends.android.AndroidInput;
import com.badlogic.gdx.backends.android.AndroidMouseHandler;
import com.badlogic.gdx.backends.android.AndroidTouchHandler;
import com.badlogic.gdx.backends.android.surfaceview.GLSurfaceView20;
import com.badlogic.gdx.utils.Pool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DefaultAndroidInput
extends AbstractInput
implements AndroidInput {
    Pool<KeyEvent> usedKeyEvents = new Pool<KeyEvent>(16, 1000){

        protected KeyEvent newObject() {
            return new KeyEvent();
        }
    };
    Pool<TouchEvent> usedTouchEvents = new Pool<TouchEvent>(16, 1000){

        protected TouchEvent newObject() {
            return new TouchEvent();
        }
    };
    public static final int NUM_TOUCHES = 20;
    ArrayList<View.OnKeyListener> keyListeners = new ArrayList();
    ArrayList<KeyEvent> keyEvents = new ArrayList();
    ArrayList<TouchEvent> touchEvents = new ArrayList();
    int[] touchX = new int[20];
    int[] touchY = new int[20];
    int[] deltaX = new int[20];
    int[] deltaY = new int[20];
    boolean[] touched = new boolean[20];
    int[] button = new int[20];
    int[] realId = new int[20];
    float[] pressure = new float[20];
    final boolean hasMultitouch;
    private boolean[] justPressedButtons = new boolean[20];
    private SensorManager manager;
    public boolean accelerometerAvailable = false;
    protected final float[] accelerometerValues = new float[3];
    public boolean gyroscopeAvailable = false;
    protected final float[] gyroscopeValues = new float[3];
    private Handler handle;
    final Application app;
    final Context context;
    protected final AndroidTouchHandler touchHandler;
    private int sleepTime = 0;
    protected final Vibrator vibrator;
    private boolean compassAvailable = false;
    private boolean rotationVectorAvailable = false;
    boolean keyboardAvailable;
    protected final float[] magneticFieldValues = new float[3];
    protected final float[] rotationVectorValues = new float[3];
    private float azimuth = 0.0f;
    private float pitch = 0.0f;
    private float roll = 0.0f;
    private boolean justTouched = false;
    private InputProcessor processor;
    private final AndroidApplicationConfiguration config;
    protected final Input.Orientation nativeOrientation;
    private long currentEventTimeStamp = 0L;
    private SensorEventListener accelerometerListener;
    private SensorEventListener gyroscopeListener;
    private SensorEventListener compassListener;
    private SensorEventListener rotationVectorListener;
    private final ArrayList<View.OnGenericMotionListener> genericMotionListeners = new ArrayList();
    private final AndroidMouseHandler mouseHandler;
    boolean requestFocus = true;
    final float[] R = new float[9];
    final float[] orientation = new float[3];

    public DefaultAndroidInput(Application activity, Context context, Object view, AndroidApplicationConfiguration config) {
        if (view instanceof View) {
            View v = (View)view;
            v.setOnKeyListener((View.OnKeyListener)this);
            v.setOnTouchListener((View.OnTouchListener)this);
            v.setFocusable(true);
            v.setFocusableInTouchMode(true);
            v.requestFocus();
            v.setOnGenericMotionListener((View.OnGenericMotionListener)this);
        }
        this.config = config;
        this.mouseHandler = new AndroidMouseHandler();
        for (int i = 0; i < this.realId.length; ++i) {
            this.realId[i] = -1;
        }
        this.handle = new Handler();
        this.app = activity;
        this.context = context;
        this.sleepTime = config.touchSleepTime;
        this.touchHandler = new AndroidTouchHandler();
        this.hasMultitouch = this.touchHandler.supportsMultitouch(context);
        this.vibrator = (Vibrator)context.getSystemService("vibrator");
        int rotation = this.getRotation();
        Graphics.DisplayMode mode = this.app.getGraphics().getDisplayMode();
        this.nativeOrientation = (rotation == 0 || rotation == 180) && mode.width >= mode.height || (rotation == 90 || rotation == 270) && mode.width <= mode.height ? Input.Orientation.Landscape : Input.Orientation.Portrait;
        this.setCatchKey(255, true);
    }

    public float getAccelerometerX() {
        return this.accelerometerValues[0];
    }

    public float getAccelerometerY() {
        return this.accelerometerValues[1];
    }

    public float getAccelerometerZ() {
        return this.accelerometerValues[2];
    }

    public float getGyroscopeX() {
        return this.gyroscopeValues[0];
    }

    public float getGyroscopeY() {
        return this.gyroscopeValues[1];
    }

    public float getGyroscopeZ() {
        return this.gyroscopeValues[2];
    }

    public void getTextInput(Input.TextInputListener listener, String title, String text, String hint) {
        this.getTextInput(listener, title, text, hint, Input.OnscreenKeyboardType.Default);
    }

    public void getTextInput(final Input.TextInputListener listener, final String title, final String text, final String hint, final Input.OnscreenKeyboardType keyboardType) {
        this.handle.post(new Runnable(){

            @Override
            public void run() {
                AlertDialog.Builder alert = new AlertDialog.Builder(DefaultAndroidInput.this.context);
                alert.setTitle((CharSequence)title);
                final EditText input = new EditText(DefaultAndroidInput.this.context);
                if (keyboardType != Input.OnscreenKeyboardType.Default) {
                    input.setInputType(DefaultAndroidInput.getAndroidInputType(keyboardType));
                }
                input.setHint((CharSequence)hint);
                input.setText((CharSequence)text);
                input.setSingleLine();
                if (keyboardType == Input.OnscreenKeyboardType.Password) {
                    input.setTransformationMethod((TransformationMethod)new PasswordTransformationMethod());
                }
                alert.setView((View)input);
                alert.setPositiveButton((CharSequence)DefaultAndroidInput.this.context.getString(17039370), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        Gdx.app.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                listener.input(input.getText().toString());
                            }
                        });
                    }
                });
                alert.setNegativeButton((CharSequence)DefaultAndroidInput.this.context.getString(0x1040000), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        Gdx.app.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                listener.canceled();
                            }
                        });
                    }
                });
                alert.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface arg0) {
                        Gdx.app.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                listener.canceled();
                            }
                        });
                    }
                });
                alert.show();
            }
        });
    }

    public static int getAndroidInputType(Input.OnscreenKeyboardType type) {
        int inputType;
        switch (type) {
            case NumberPad: {
                inputType = 2;
                break;
            }
            case PhonePad: {
                inputType = 3;
                break;
            }
            case Email: {
                inputType = 33;
                break;
            }
            case Password: {
                inputType = 129;
                break;
            }
            case URI: {
                inputType = 17;
                break;
            }
            default: {
                inputType = 144;
            }
        }
        return inputType;
    }

    public int getMaxPointers() {
        return 20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getX() {
        DefaultAndroidInput defaultAndroidInput = this;
        synchronized (defaultAndroidInput) {
            return this.touchX[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getY() {
        DefaultAndroidInput defaultAndroidInput = this;
        synchronized (defaultAndroidInput) {
            return this.touchY[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getX(int pointer) {
        DefaultAndroidInput defaultAndroidInput = this;
        synchronized (defaultAndroidInput) {
            return this.touchX[pointer];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getY(int pointer) {
        DefaultAndroidInput defaultAndroidInput = this;
        synchronized (defaultAndroidInput) {
            return this.touchY[pointer];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTouched(int pointer) {
        DefaultAndroidInput defaultAndroidInput = this;
        synchronized (defaultAndroidInput) {
            return this.touched[pointer];
        }
    }

    public float getPressure() {
        return this.getPressure(0);
    }

    public float getPressure(int pointer) {
        return this.pressure[pointer];
    }

    @Override
    public void setKeyboardAvailable(boolean available) {
        this.keyboardAvailable = available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTouched() {
        DefaultAndroidInput defaultAndroidInput = this;
        synchronized (defaultAndroidInput) {
            if (this.hasMultitouch) {
                for (int pointer = 0; pointer < 20; ++pointer) {
                    if (!this.touched[pointer]) continue;
                    return true;
                }
            }
            return this.touched[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputProcessor(InputProcessor processor) {
        DefaultAndroidInput defaultAndroidInput = this;
        synchronized (defaultAndroidInput) {
            this.processor = processor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processEvents() {
        DefaultAndroidInput defaultAndroidInput = this;
        synchronized (defaultAndroidInput) {
            int i;
            if (this.justTouched) {
                this.justTouched = false;
                for (i = 0; i < this.justPressedButtons.length; ++i) {
                    this.justPressedButtons[i] = false;
                }
            }
            if (this.keyJustPressed) {
                this.keyJustPressed = false;
                for (i = 0; i < this.justPressedKeys.length; ++i) {
                    this.justPressedKeys[i] = false;
                }
            }
            if (this.processor != null) {
                Object e;
                int i2;
                InputProcessor processor = this.processor;
                int len = this.keyEvents.size();
                for (i2 = 0; i2 < len; ++i2) {
                    e = this.keyEvents.get(i2);
                    this.currentEventTimeStamp = ((KeyEvent)e).timeStamp;
                    switch (((KeyEvent)e).type) {
                        case 0: {
                            processor.keyDown(((KeyEvent)e).keyCode);
                            this.keyJustPressed = true;
                            this.justPressedKeys[((KeyEvent)e).keyCode] = true;
                            break;
                        }
                        case 1: {
                            processor.keyUp(((KeyEvent)e).keyCode);
                            break;
                        }
                        case 2: {
                            processor.keyTyped(((KeyEvent)e).keyChar);
                        }
                    }
                    this.usedKeyEvents.free(e);
                }
                len = this.touchEvents.size();
                for (i2 = 0; i2 < len; ++i2) {
                    e = this.touchEvents.get(i2);
                    this.currentEventTimeStamp = ((TouchEvent)e).timeStamp;
                    switch (((TouchEvent)e).type) {
                        case 0: {
                            processor.touchDown(((TouchEvent)e).x, ((TouchEvent)e).y, ((TouchEvent)e).pointer, ((TouchEvent)e).button);
                            this.justTouched = true;
                            this.justPressedButtons[((TouchEvent)e).button] = true;
                            break;
                        }
                        case 1: {
                            processor.touchUp(((TouchEvent)e).x, ((TouchEvent)e).y, ((TouchEvent)e).pointer, ((TouchEvent)e).button);
                            break;
                        }
                        case 2: {
                            processor.touchDragged(((TouchEvent)e).x, ((TouchEvent)e).y, ((TouchEvent)e).pointer);
                            break;
                        }
                        case 4: {
                            processor.mouseMoved(((TouchEvent)e).x, ((TouchEvent)e).y);
                            break;
                        }
                        case 3: {
                            processor.scrolled((float)((TouchEvent)e).scrollAmountX, (float)((TouchEvent)e).scrollAmountY);
                        }
                    }
                    this.usedTouchEvents.free(e);
                }
            } else {
                int i3;
                int len = this.touchEvents.size();
                for (i3 = 0; i3 < len; ++i3) {
                    TouchEvent e = this.touchEvents.get(i3);
                    if (e.type == 0) {
                        this.justTouched = true;
                    }
                    this.usedTouchEvents.free((Object)e);
                }
                len = this.keyEvents.size();
                for (i3 = 0; i3 < len; ++i3) {
                    this.usedKeyEvents.free((Object)this.keyEvents.get(i3));
                }
            }
            if (this.touchEvents.isEmpty()) {
                for (int i4 = 0; i4 < this.deltaX.length; ++i4) {
                    this.deltaX[0] = 0;
                    this.deltaY[0] = 0;
                }
            }
            this.keyEvents.clear();
            this.touchEvents.clear();
        }
    }

    public boolean onTouch(View view, MotionEvent event) {
        if (this.requestFocus && view != null) {
            view.setFocusableInTouchMode(true);
            view.requestFocus();
            this.requestFocus = false;
        }
        this.touchHandler.onTouch(event, this);
        if (this.sleepTime != 0) {
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onKey(View v, int keyCode, android.view.KeyEvent e) {
        int n = this.keyListeners.size();
        for (int i = 0; i < n; ++i) {
            if (!this.keyListeners.get(i).onKey(v, keyCode, e)) continue;
            return true;
        }
        if (e.getAction() == 0 && e.getRepeatCount() > 0) {
            return this.isCatchKey(keyCode);
        }
        DefaultAndroidInput defaultAndroidInput = this;
        synchronized (defaultAndroidInput) {
            KeyEvent event = null;
            if (e.getKeyCode() == 0 && e.getAction() == 2) {
                String chars = e.getCharacters();
                for (int i = 0; i < chars.length(); ++i) {
                    event = (KeyEvent)this.usedKeyEvents.obtain();
                    event.timeStamp = System.nanoTime();
                    event.keyCode = 0;
                    event.keyChar = chars.charAt(i);
                    event.type = 2;
                    this.keyEvents.add(event);
                }
                return false;
            }
            int character = e.getUnicodeChar();
            if (keyCode == 67) {
                character = 8;
            }
            if (e.getKeyCode() < 0 || e.getKeyCode() > 255) {
                return false;
            }
            switch (e.getAction()) {
                case 0: {
                    event = (KeyEvent)this.usedKeyEvents.obtain();
                    event.timeStamp = System.nanoTime();
                    event.keyChar = '\u0000';
                    event.keyCode = e.getKeyCode();
                    event.type = 0;
                    if (keyCode == 4 && e.isAltPressed()) {
                        event.keyCode = keyCode = 255;
                    }
                    this.keyEvents.add(event);
                    if (this.pressedKeys[event.keyCode]) break;
                    ++this.pressedKeyCount;
                    this.pressedKeys[event.keyCode] = true;
                    break;
                }
                case 1: {
                    long timeStamp = System.nanoTime();
                    event = (KeyEvent)this.usedKeyEvents.obtain();
                    event.timeStamp = timeStamp;
                    event.keyChar = '\u0000';
                    event.keyCode = e.getKeyCode();
                    event.type = 1;
                    if (keyCode == 4 && e.isAltPressed()) {
                        event.keyCode = keyCode = 255;
                    }
                    this.keyEvents.add(event);
                    event = (KeyEvent)this.usedKeyEvents.obtain();
                    event.timeStamp = timeStamp;
                    event.keyChar = (char)character;
                    event.keyCode = 0;
                    event.type = 2;
                    this.keyEvents.add(event);
                    if (keyCode == 255) {
                        if (!this.pressedKeys[255]) break;
                        --this.pressedKeyCount;
                        this.pressedKeys[255] = false;
                        break;
                    }
                    if (!this.pressedKeys[e.getKeyCode()]) break;
                    --this.pressedKeyCount;
                    this.pressedKeys[e.getKeyCode()] = false;
                }
            }
            this.app.getGraphics().requestRendering();
        }
        return this.isCatchKey(keyCode);
    }

    public void setOnscreenKeyboardVisible(boolean visible) {
        this.setOnscreenKeyboardVisible(visible, Input.OnscreenKeyboardType.Default);
    }

    public void setOnscreenKeyboardVisible(final boolean visible, final Input.OnscreenKeyboardType type) {
        this.handle.post(new Runnable(){

            @Override
            public void run() {
                InputMethodManager manager = (InputMethodManager)DefaultAndroidInput.this.context.getSystemService("input_method");
                if (visible) {
                    Input.OnscreenKeyboardType tmp;
                    View view = ((AndroidGraphics)DefaultAndroidInput.this.app.getGraphics()).getView();
                    Input.OnscreenKeyboardType onscreenKeyboardType = tmp = type == null ? Input.OnscreenKeyboardType.Default : type;
                    if (((GLSurfaceView20)view).onscreenKeyboardType != tmp) {
                        ((GLSurfaceView20)view).onscreenKeyboardType = tmp;
                        manager.restartInput(view);
                    }
                    view.setFocusable(true);
                    view.setFocusableInTouchMode(true);
                    manager.showSoftInput(((AndroidGraphics)DefaultAndroidInput.this.app.getGraphics()).getView(), 0);
                } else {
                    manager.hideSoftInputFromWindow(((AndroidGraphics)DefaultAndroidInput.this.app.getGraphics()).getView().getWindowToken(), 0);
                }
            }
        });
    }

    public void vibrate(int milliseconds) {
        if (Build.VERSION.SDK_INT >= 26) {
            this.vibrator.vibrate(VibrationEffect.createOneShot((long)milliseconds, (int)-1));
        } else {
            this.vibrator.vibrate((long)milliseconds);
        }
    }

    public void vibrate(long[] pattern, int repeat) {
        if (Build.VERSION.SDK_INT >= 26) {
            this.vibrator.vibrate(VibrationEffect.createWaveform((long[])pattern, (int)repeat));
        } else {
            this.vibrator.vibrate(pattern, repeat);
        }
    }

    public void cancelVibrate() {
        this.vibrator.cancel();
    }

    public boolean justTouched() {
        return this.justTouched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isButtonPressed(int button) {
        DefaultAndroidInput defaultAndroidInput = this;
        synchronized (defaultAndroidInput) {
            if (this.hasMultitouch) {
                for (int pointer = 0; pointer < 20; ++pointer) {
                    if (!this.touched[pointer] || this.button[pointer] != button) continue;
                    return true;
                }
            }
            return this.touched[0] && this.button[0] == button;
        }
    }

    public boolean isButtonJustPressed(int button) {
        if (button < 0 || button > 20) {
            return false;
        }
        return this.justPressedButtons[button];
    }

    private void updateOrientation() {
        if (this.rotationVectorAvailable) {
            SensorManager.getRotationMatrixFromVector((float[])this.R, (float[])this.rotationVectorValues);
        } else if (!SensorManager.getRotationMatrix((float[])this.R, null, (float[])this.accelerometerValues, (float[])this.magneticFieldValues)) {
            return;
        }
        SensorManager.getOrientation((float[])this.R, (float[])this.orientation);
        this.azimuth = (float)Math.toDegrees(this.orientation[0]);
        this.pitch = (float)Math.toDegrees(this.orientation[1]);
        this.roll = (float)Math.toDegrees(this.orientation[2]);
    }

    public void getRotationMatrix(float[] matrix) {
        if (this.rotationVectorAvailable) {
            SensorManager.getRotationMatrixFromVector((float[])matrix, (float[])this.rotationVectorValues);
        } else {
            SensorManager.getRotationMatrix((float[])matrix, null, (float[])this.accelerometerValues, (float[])this.magneticFieldValues);
        }
    }

    public float getAzimuth() {
        if (!this.compassAvailable && !this.rotationVectorAvailable) {
            return 0.0f;
        }
        this.updateOrientation();
        return this.azimuth;
    }

    public float getPitch() {
        if (!this.compassAvailable && !this.rotationVectorAvailable) {
            return 0.0f;
        }
        this.updateOrientation();
        return this.pitch;
    }

    public float getRoll() {
        if (!this.compassAvailable && !this.rotationVectorAvailable) {
            return 0.0f;
        }
        this.updateOrientation();
        return this.roll;
    }

    void registerSensorListeners() {
        if (this.config.useAccelerometer) {
            this.manager = (SensorManager)this.context.getSystemService("sensor");
            if (this.manager.getSensorList(1).isEmpty()) {
                this.accelerometerAvailable = false;
            } else {
                Sensor accelerometer = (Sensor)this.manager.getSensorList(1).get(0);
                this.accelerometerListener = new SensorListener();
                this.accelerometerAvailable = this.manager.registerListener(this.accelerometerListener, accelerometer, this.config.sensorDelay);
            }
        } else {
            this.accelerometerAvailable = false;
        }
        if (this.config.useGyroscope) {
            this.manager = (SensorManager)this.context.getSystemService("sensor");
            if (this.manager.getSensorList(4).isEmpty()) {
                this.gyroscopeAvailable = false;
            } else {
                Sensor gyroscope = (Sensor)this.manager.getSensorList(4).get(0);
                this.gyroscopeListener = new SensorListener();
                this.gyroscopeAvailable = this.manager.registerListener(this.gyroscopeListener, gyroscope, this.config.sensorDelay);
            }
        } else {
            this.gyroscopeAvailable = false;
        }
        this.rotationVectorAvailable = false;
        if (this.config.useRotationVectorSensor) {
            List rotationVectorSensors;
            if (this.manager == null) {
                this.manager = (SensorManager)this.context.getSystemService("sensor");
            }
            if (!(rotationVectorSensors = this.manager.getSensorList(11)).isEmpty()) {
                this.rotationVectorListener = new SensorListener();
                for (Sensor sensor : rotationVectorSensors) {
                    if (!sensor.getVendor().equals("Google Inc.") || sensor.getVersion() != 3) continue;
                    this.rotationVectorAvailable = this.manager.registerListener(this.rotationVectorListener, sensor, this.config.sensorDelay);
                    break;
                }
                if (!this.rotationVectorAvailable) {
                    this.rotationVectorAvailable = this.manager.registerListener(this.rotationVectorListener, (Sensor)rotationVectorSensors.get(0), this.config.sensorDelay);
                }
            }
        }
        if (this.config.useCompass && !this.rotationVectorAvailable) {
            Sensor sensor;
            if (this.manager == null) {
                this.manager = (SensorManager)this.context.getSystemService("sensor");
            }
            if ((sensor = this.manager.getDefaultSensor(2)) != null) {
                this.compassAvailable = this.accelerometerAvailable;
                if (this.compassAvailable) {
                    this.compassListener = new SensorListener();
                    this.compassAvailable = this.manager.registerListener(this.compassListener, sensor, this.config.sensorDelay);
                }
            } else {
                this.compassAvailable = false;
            }
        } else {
            this.compassAvailable = false;
        }
        Gdx.app.log("AndroidInput", "sensor listener setup");
    }

    void unregisterSensorListeners() {
        if (this.manager != null) {
            if (this.accelerometerListener != null) {
                this.manager.unregisterListener(this.accelerometerListener);
                this.accelerometerListener = null;
            }
            if (this.gyroscopeListener != null) {
                this.manager.unregisterListener(this.gyroscopeListener);
                this.gyroscopeListener = null;
            }
            if (this.rotationVectorListener != null) {
                this.manager.unregisterListener(this.rotationVectorListener);
                this.rotationVectorListener = null;
            }
            if (this.compassListener != null) {
                this.manager.unregisterListener(this.compassListener);
                this.compassListener = null;
            }
            this.manager = null;
        }
        Gdx.app.log("AndroidInput", "sensor listener tear down");
    }

    public InputProcessor getInputProcessor() {
        return this.processor;
    }

    public boolean isPeripheralAvailable(Input.Peripheral peripheral) {
        if (peripheral == Input.Peripheral.Accelerometer) {
            return this.accelerometerAvailable;
        }
        if (peripheral == Input.Peripheral.Gyroscope) {
            return this.gyroscopeAvailable;
        }
        if (peripheral == Input.Peripheral.Compass) {
            return this.compassAvailable;
        }
        if (peripheral == Input.Peripheral.HardwareKeyboard) {
            return this.keyboardAvailable;
        }
        if (peripheral == Input.Peripheral.OnscreenKeyboard) {
            return true;
        }
        if (peripheral == Input.Peripheral.Vibrator) {
            return this.vibrator != null && this.vibrator.hasVibrator();
        }
        if (peripheral == Input.Peripheral.MultitouchScreen) {
            return this.hasMultitouch;
        }
        if (peripheral == Input.Peripheral.RotationVector) {
            return this.rotationVectorAvailable;
        }
        return peripheral == Input.Peripheral.Pressure;
    }

    public int getFreePointerIndex() {
        int len = this.realId.length;
        for (int i = 0; i < len; ++i) {
            if (this.realId[i] != -1) continue;
            return i;
        }
        this.pressure = this.resize(this.pressure);
        this.realId = this.resize(this.realId);
        this.touchX = this.resize(this.touchX);
        this.touchY = this.resize(this.touchY);
        this.deltaX = this.resize(this.deltaX);
        this.deltaY = this.resize(this.deltaY);
        this.touched = this.resize(this.touched);
        this.button = this.resize(this.button);
        return len;
    }

    private int[] resize(int[] orig) {
        int[] tmp = new int[orig.length + 2];
        System.arraycopy(orig, 0, tmp, 0, orig.length);
        return tmp;
    }

    private boolean[] resize(boolean[] orig) {
        boolean[] tmp = new boolean[orig.length + 2];
        System.arraycopy(orig, 0, tmp, 0, orig.length);
        return tmp;
    }

    private float[] resize(float[] orig) {
        float[] tmp = new float[orig.length + 2];
        System.arraycopy(orig, 0, tmp, 0, orig.length);
        return tmp;
    }

    public int lookUpPointerIndex(int pointerId) {
        int len = this.realId.length;
        for (int i = 0; i < len; ++i) {
            if (this.realId[i] != pointerId) continue;
            return i;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(i + ":" + this.realId[i] + " ");
        }
        Gdx.app.log("AndroidInput", "Pointer ID lookup failed: " + pointerId + ", " + sb.toString());
        return -1;
    }

    public int getRotation() {
        int orientation = 0;
        orientation = this.context instanceof Activity ? ((Activity)this.context).getWindowManager().getDefaultDisplay().getRotation() : ((WindowManager)this.context.getSystemService("window")).getDefaultDisplay().getRotation();
        switch (orientation) {
            case 0: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    public Input.Orientation getNativeOrientation() {
        return this.nativeOrientation;
    }

    public void setCursorCatched(boolean catched) {
    }

    public boolean isCursorCatched() {
        return false;
    }

    public int getDeltaX() {
        return this.deltaX[0];
    }

    public int getDeltaX(int pointer) {
        return this.deltaX[pointer];
    }

    public int getDeltaY() {
        return this.deltaY[0];
    }

    public int getDeltaY(int pointer) {
        return this.deltaY[pointer];
    }

    public void setCursorPosition(int x, int y) {
    }

    public long getCurrentEventTime() {
        return this.currentEventTimeStamp;
    }

    @Override
    public void addKeyListener(View.OnKeyListener listener) {
        this.keyListeners.add(listener);
    }

    public boolean onGenericMotion(View view, MotionEvent event) {
        if (this.mouseHandler.onGenericMotion(event, this)) {
            return true;
        }
        int n = this.genericMotionListeners.size();
        for (int i = 0; i < n; ++i) {
            if (!this.genericMotionListeners.get(i).onGenericMotion(view, event)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addGenericMotionListener(View.OnGenericMotionListener listener) {
        this.genericMotionListeners.add(listener);
    }

    @Override
    public void onPause() {
        this.unregisterSensorListeners();
        Arrays.fill(this.realId, -1);
        Arrays.fill(this.touched, false);
    }

    @Override
    public void onResume() {
        this.registerSensorListeners();
    }

    @Override
    public void onDreamingStarted() {
        this.registerSensorListeners();
    }

    @Override
    public void onDreamingStopped() {
        this.unregisterSensorListeners();
        Arrays.fill(this.realId, -1);
        Arrays.fill(this.touched, false);
    }

    private class SensorListener
    implements SensorEventListener {
        public void onAccuracyChanged(Sensor arg0, int arg1) {
        }

        public void onSensorChanged(SensorEvent event) {
            if (event.sensor.getType() == 1) {
                if (DefaultAndroidInput.this.nativeOrientation == Input.Orientation.Portrait) {
                    System.arraycopy(event.values, 0, DefaultAndroidInput.this.accelerometerValues, 0, DefaultAndroidInput.this.accelerometerValues.length);
                } else {
                    DefaultAndroidInput.this.accelerometerValues[0] = event.values[1];
                    DefaultAndroidInput.this.accelerometerValues[1] = -event.values[0];
                    DefaultAndroidInput.this.accelerometerValues[2] = event.values[2];
                }
            }
            if (event.sensor.getType() == 2) {
                System.arraycopy(event.values, 0, DefaultAndroidInput.this.magneticFieldValues, 0, DefaultAndroidInput.this.magneticFieldValues.length);
            }
            if (event.sensor.getType() == 4) {
                if (DefaultAndroidInput.this.nativeOrientation == Input.Orientation.Portrait) {
                    System.arraycopy(event.values, 0, DefaultAndroidInput.this.gyroscopeValues, 0, DefaultAndroidInput.this.gyroscopeValues.length);
                } else {
                    DefaultAndroidInput.this.gyroscopeValues[0] = event.values[1];
                    DefaultAndroidInput.this.gyroscopeValues[1] = -event.values[0];
                    DefaultAndroidInput.this.gyroscopeValues[2] = event.values[2];
                }
            }
            if (event.sensor.getType() == 11) {
                if (DefaultAndroidInput.this.nativeOrientation == Input.Orientation.Portrait) {
                    System.arraycopy(event.values, 0, DefaultAndroidInput.this.rotationVectorValues, 0, DefaultAndroidInput.this.rotationVectorValues.length);
                } else {
                    DefaultAndroidInput.this.rotationVectorValues[0] = event.values[1];
                    DefaultAndroidInput.this.rotationVectorValues[1] = -event.values[0];
                    DefaultAndroidInput.this.rotationVectorValues[2] = event.values[2];
                }
            }
        }
    }

    static class TouchEvent {
        static final int TOUCH_DOWN = 0;
        static final int TOUCH_UP = 1;
        static final int TOUCH_DRAGGED = 2;
        static final int TOUCH_SCROLLED = 3;
        static final int TOUCH_MOVED = 4;
        long timeStamp;
        int type;
        int x;
        int y;
        int scrollAmountX;
        int scrollAmountY;
        int button;
        int pointer;

        TouchEvent() {
        }
    }

    static class KeyEvent {
        static final int KEY_DOWN = 0;
        static final int KEY_UP = 1;
        static final int KEY_TYPED = 2;
        long timeStamp;
        int type;
        int keyCode;
        char keyChar;

        KeyEvent() {
        }
    }
}

