/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.content.Context;
import android.view.MotionEvent;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.android.DefaultAndroidInput;

public class AndroidTouchHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTouch(MotionEvent event, DefaultAndroidInput input) {
        int action = event.getAction() & 0xFF;
        int pointerIndex = (event.getAction() & 0xFF00) >> 8;
        int pointerId = event.getPointerId(pointerIndex);
        int x = 0;
        int y = 0;
        int realPointerIndex = 0;
        int button = 0;
        long timeStamp = System.nanoTime();
        DefaultAndroidInput defaultAndroidInput = input;
        synchronized (defaultAndroidInput) {
            block2 : switch (action) {
                case 0: 
                case 5: {
                    realPointerIndex = input.getFreePointerIndex();
                    if (realPointerIndex >= 20) break;
                    input.realId[realPointerIndex] = pointerId;
                    x = (int)event.getX(pointerIndex);
                    y = (int)event.getY(pointerIndex);
                    button = this.toGdxButton(event.getButtonState());
                    if (button != -1) {
                        this.postTouchEvent(input, 0, x, y, realPointerIndex, button, timeStamp);
                    }
                    input.touchX[realPointerIndex] = x;
                    input.touchY[realPointerIndex] = y;
                    input.deltaX[realPointerIndex] = 0;
                    input.deltaY[realPointerIndex] = 0;
                    input.touched[realPointerIndex] = button != -1;
                    input.button[realPointerIndex] = button;
                    input.pressure[realPointerIndex] = event.getPressure(pointerIndex);
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    realPointerIndex = input.lookUpPointerIndex(pointerId);
                    if (realPointerIndex == -1 || realPointerIndex >= 20) break;
                    input.realId[realPointerIndex] = -1;
                    x = (int)event.getX(pointerIndex);
                    y = (int)event.getY(pointerIndex);
                    button = input.button[realPointerIndex];
                    if (button != -1) {
                        this.postTouchEvent(input, 1, x, y, realPointerIndex, button, timeStamp);
                    }
                    input.touchX[realPointerIndex] = x;
                    input.touchY[realPointerIndex] = y;
                    input.deltaX[realPointerIndex] = 0;
                    input.deltaY[realPointerIndex] = 0;
                    input.touched[realPointerIndex] = false;
                    input.button[realPointerIndex] = 0;
                    input.pressure[realPointerIndex] = 0.0f;
                    break;
                }
                case 3: {
                    for (int i = 0; i < input.realId.length; ++i) {
                        input.realId[i] = -1;
                        input.touchX[i] = 0;
                        input.touchY[i] = 0;
                        input.deltaX[i] = 0;
                        input.deltaY[i] = 0;
                        input.touched[i] = false;
                        input.button[i] = 0;
                        input.pressure[i] = 0.0f;
                    }
                    break;
                }
                case 2: {
                    int pointerCount = event.getPointerCount();
                    for (int i = 0; i < pointerCount; ++i) {
                        pointerIndex = i;
                        pointerId = event.getPointerId(pointerIndex);
                        x = (int)event.getX(pointerIndex);
                        y = (int)event.getY(pointerIndex);
                        realPointerIndex = input.lookUpPointerIndex(pointerId);
                        if (realPointerIndex == -1) continue;
                        if (realPointerIndex >= 20) break block2;
                        button = input.button[realPointerIndex];
                        if (button != -1) {
                            this.postTouchEvent(input, 2, x, y, realPointerIndex, button, timeStamp);
                        } else {
                            this.postTouchEvent(input, 4, x, y, realPointerIndex, 0, timeStamp);
                        }
                        input.deltaX[realPointerIndex] = x - input.touchX[realPointerIndex];
                        input.deltaY[realPointerIndex] = y - input.touchY[realPointerIndex];
                        input.touchX[realPointerIndex] = x;
                        input.touchY[realPointerIndex] = y;
                        input.pressure[realPointerIndex] = event.getPressure(pointerIndex);
                    }
                    break;
                }
            }
        }
        Gdx.app.getGraphics().requestRendering();
    }

    private void logAction(int action, int pointer) {
        String actionStr = "";
        actionStr = action == 0 ? "DOWN" : (action == 5 ? "POINTER DOWN" : (action == 1 ? "UP" : (action == 6 ? "POINTER UP" : (action == 4 ? "OUTSIDE" : (action == 3 ? "CANCEL" : (action == 2 ? "MOVE" : "UNKNOWN (" + action + ")"))))));
        Gdx.app.log("AndroidMultiTouchHandler", "action " + actionStr + ", Android pointer id: " + pointer);
    }

    private int toGdxButton(int button) {
        if (button == 0 || button == 1) {
            return 0;
        }
        if (button == 2) {
            return 1;
        }
        if (button == 4) {
            return 2;
        }
        if (button == 8) {
            return 3;
        }
        if (button == 16) {
            return 4;
        }
        return -1;
    }

    private void postTouchEvent(DefaultAndroidInput input, int type, int x, int y, int pointer, int button, long timeStamp) {
        DefaultAndroidInput.TouchEvent event = (DefaultAndroidInput.TouchEvent)input.usedTouchEvents.obtain();
        event.timeStamp = timeStamp;
        event.pointer = pointer;
        event.x = x;
        event.y = y;
        event.type = type;
        event.button = button;
        input.touchEvents.add(event);
    }

    public boolean supportsMultitouch(Context activity) {
        return activity.getPackageManager().hasSystemFeature("android.hardware.touchscreen.multitouch");
    }
}

