/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.backends.android.AndroidApplicationConfiguration;
import com.badlogic.gdx.backends.android.AsynchronousSound;
import com.badlogic.gdx.backends.android.DefaultAndroidAudio;
import com.badlogic.gdx.files.FileHandle;

public class AsynchronousAndroidAudio
extends DefaultAndroidAudio {
    private final HandlerThread handlerThread;
    private final Handler handler;

    public AsynchronousAndroidAudio(Context context, AndroidApplicationConfiguration config) {
        super(context, config);
        if (!config.disableAudio) {
            this.handlerThread = new HandlerThread("libGDX Sound Management");
            this.handlerThread.start();
            this.handler = new Handler(this.handlerThread.getLooper());
        } else {
            this.handler = null;
            this.handlerThread = null;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.handlerThread != null) {
            this.handlerThread.quit();
        }
    }

    @Override
    public Sound newSound(FileHandle file) {
        Sound sound = super.newSound(file);
        return new AsynchronousSound(sound, this.handler);
    }
}

