/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.AssetManager;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.android.APKExpansionSupport;
import com.badlogic.gdx.backends.android.AndroidFileHandle;
import com.badlogic.gdx.backends.android.AndroidZipFileHandle;
import com.badlogic.gdx.backends.android.ZipResourceFile;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.File;
import java.io.IOException;

public class AndroidFiles
implements Files {
    protected final String externalFilesPath;
    protected final String localpath;
    protected final AssetManager assets;
    private ZipResourceFile expansionFile = null;

    public AndroidFiles(AssetManager assets, ContextWrapper contextWrapper) {
        String externalFilesPath;
        this.assets = assets;
        String localPath = contextWrapper.getFilesDir().getAbsolutePath();
        this.localpath = localPath.endsWith("/") ? localPath : localPath + "/";
        File externalFilesDir = contextWrapper.getExternalFilesDir(null);
        this.externalFilesPath = externalFilesDir != null ? ((externalFilesPath = externalFilesDir.getAbsolutePath()).endsWith("/") ? externalFilesPath : externalFilesPath + "/") : null;
    }

    public FileHandle getFileHandle(String path, Files.FileType type) {
        AndroidFileHandle handle = new AndroidFileHandle(type == Files.FileType.Internal ? this.assets : null, path, type);
        if (this.expansionFile != null && type == Files.FileType.Internal) {
            handle = this.getZipFileHandleIfExists(handle, path);
        }
        return handle;
    }

    private FileHandle getZipFileHandleIfExists(FileHandle handle, String path) {
        try {
            this.assets.open(path).close();
            return handle;
        }
        catch (Exception ex) {
            AndroidZipFileHandle zipHandle = new AndroidZipFileHandle(path);
            if (!zipHandle.isDirectory()) {
                return zipHandle;
            }
            if (zipHandle.exists()) {
                return zipHandle;
            }
            return handle;
        }
    }

    public FileHandle classpath(String path) {
        return new AndroidFileHandle(null, path, Files.FileType.Classpath);
    }

    public FileHandle internal(String path) {
        AndroidFileHandle handle = new AndroidFileHandle(this.assets, path, Files.FileType.Internal);
        if (this.expansionFile != null) {
            handle = this.getZipFileHandleIfExists(handle, path);
        }
        return handle;
    }

    public FileHandle external(String path) {
        return new AndroidFileHandle(null, path, Files.FileType.External);
    }

    public FileHandle absolute(String path) {
        return new AndroidFileHandle(null, path, Files.FileType.Absolute);
    }

    public FileHandle local(String path) {
        return new AndroidFileHandle(null, path, Files.FileType.Local);
    }

    public String getExternalStoragePath() {
        return this.externalFilesPath;
    }

    public boolean isExternalStorageAvailable() {
        return this.externalFilesPath != null;
    }

    public String getLocalStoragePath() {
        return this.localpath;
    }

    public boolean isLocalStorageAvailable() {
        return true;
    }

    public boolean setAPKExpansion(int mainVersion, int patchVersion) {
        try {
            Context context;
            if (Gdx.app instanceof Activity) {
                context = ((Activity)Gdx.app).getBaseContext();
            } else if (Gdx.app instanceof Fragment) {
                context = ((Fragment)Gdx.app).getActivity().getBaseContext();
            } else {
                throw new GdxRuntimeException("APK expansion not supported for application type");
            }
            this.expansionFile = APKExpansionSupport.getAPKExpansionZipFile(context, mainVersion, patchVersion);
        }
        catch (IOException ex) {
            throw new GdxRuntimeException("APK expansion main version " + mainVersion + " or patch version " + patchVersion + " couldn't be opened!");
        }
        return this.expansionFile != null;
    }

    public ZipResourceFile getExpansionFile() {
        return this.expansionFile;
    }
}

