/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.view.MotionEvent;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.android.DefaultAndroidInput;

public class AndroidMouseHandler {
    private int deltaX = 0;
    private int deltaY = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onGenericMotion(MotionEvent event, DefaultAndroidInput input) {
        if ((event.getSource() & 2) == 0) {
            return false;
        }
        int action = event.getAction() & 0xFF;
        int x = 0;
        int y = 0;
        int scrollAmount = 0;
        long timeStamp = System.nanoTime();
        DefaultAndroidInput defaultAndroidInput = input;
        synchronized (defaultAndroidInput) {
            switch (action) {
                case 7: {
                    x = (int)event.getX();
                    y = (int)event.getY();
                    if (x == this.deltaX && y == this.deltaY) break;
                    this.postTouchEvent(input, 4, x, y, 0, timeStamp);
                    this.deltaX = x;
                    this.deltaY = y;
                    break;
                }
                case 8: {
                    scrollAmount = (int)(-Math.signum(event.getAxisValue(9)));
                    this.postTouchEvent(input, 3, 0, 0, scrollAmount, timeStamp);
                }
            }
        }
        Gdx.app.getGraphics().requestRendering();
        return true;
    }

    private void logAction(int action) {
        String actionStr = "";
        actionStr = action == 9 ? "HOVER_ENTER" : (action == 7 ? "HOVER_MOVE" : (action == 10 ? "HOVER_EXIT" : (action == 8 ? "SCROLL" : "UNKNOWN (" + action + ")")));
        Gdx.app.log("AndroidMouseHandler", "action " + actionStr);
    }

    private void postTouchEvent(DefaultAndroidInput input, int type, int x, int y, int scrollAmount, long timeStamp) {
        DefaultAndroidInput.TouchEvent event = (DefaultAndroidInput.TouchEvent)input.usedTouchEvents.obtain();
        event.timeStamp = timeStamp;
        event.x = x;
        event.y = y;
        event.type = type;
        event.scrollAmount = scrollAmount;
        input.touchEvents.add(event);
    }
}

