/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.opengl.GLSurfaceView;
import android.os.Build;
import android.os.Process;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.backends.android.AndroidApplicationBase;
import com.badlogic.gdx.backends.android.AndroidApplicationConfiguration;
import com.badlogic.gdx.backends.android.AndroidGL20;
import com.badlogic.gdx.backends.android.surfaceview.GLSurfaceView20;
import com.badlogic.gdx.backends.android.surfaceview.GLSurfaceView20API18;
import com.badlogic.gdx.backends.android.surfaceview.GLSurfaceViewAPI18;
import com.badlogic.gdx.backends.android.surfaceview.GdxEglConfigChooser;
import com.badlogic.gdx.backends.android.surfaceview.ResolutionStrategy;
import com.badlogic.gdx.graphics.Cubemap;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.GL30;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.WindowedMean;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.opengles.GL10;

public class AndroidGraphics
implements Graphics,
GLSurfaceView.Renderer {
    private static final String LOG_TAG = "AndroidGraphics";
    static volatile boolean enforceContinuousRendering = false;
    final View view;
    int width;
    int height;
    AndroidApplicationBase app;
    GL20 gl20;
    GL30 gl30;
    EGLContext eglContext;
    String extensions;
    protected long lastFrameTime = System.nanoTime();
    protected float deltaTime = 0.0f;
    protected long frameStart = System.nanoTime();
    protected long frameId = -1L;
    protected int frames = 0;
    protected int fps;
    protected WindowedMean mean = new WindowedMean(5);
    volatile boolean created = false;
    volatile boolean running = false;
    volatile boolean pause = false;
    volatile boolean resume = false;
    volatile boolean destroy = false;
    private float ppiX = 0.0f;
    private float ppiY = 0.0f;
    private float ppcX = 0.0f;
    private float ppcY = 0.0f;
    private float density = 1.0f;
    protected final AndroidApplicationConfiguration config;
    private Graphics.BufferFormat bufferFormat = new Graphics.BufferFormat(5, 6, 5, 0, 16, 0, 0, false);
    private boolean isContinuous = true;
    int[] value = new int[1];
    Object synch = new Object();

    public AndroidGraphics(AndroidApplicationBase application, AndroidApplicationConfiguration config, ResolutionStrategy resolutionStrategy) {
        this(application, config, resolutionStrategy, true);
    }

    public AndroidGraphics(AndroidApplicationBase application, AndroidApplicationConfiguration config, ResolutionStrategy resolutionStrategy, boolean focusableView) {
        this.config = config;
        this.app = application;
        this.view = this.createGLSurfaceView(application, resolutionStrategy);
        this.preserveEGLContextOnPause();
        if (focusableView) {
            this.view.setFocusable(true);
            this.view.setFocusableInTouchMode(true);
        }
    }

    protected void preserveEGLContextOnPause() {
        int sdkVersion = Build.VERSION.SDK_INT;
        if (sdkVersion >= 11 && this.view instanceof GLSurfaceView20 || this.view instanceof GLSurfaceView20API18) {
            try {
                this.view.getClass().getMethod("setPreserveEGLContextOnPause", Boolean.TYPE).invoke((Object)this.view, true);
            }
            catch (Exception e) {
                Gdx.app.log(LOG_TAG, "Method GLSurfaceView.setPreserveEGLContextOnPause not found");
            }
        }
    }

    protected View createGLSurfaceView(AndroidApplicationBase application, ResolutionStrategy resolutionStrategy) {
        if (!this.checkGL20()) {
            throw new GdxRuntimeException("Libgdx requires OpenGL ES 2.0");
        }
        GLSurfaceView.EGLConfigChooser configChooser = this.getEglConfigChooser();
        int sdkVersion = Build.VERSION.SDK_INT;
        if (sdkVersion <= 10 && this.config.useGLSurfaceView20API18) {
            GLSurfaceView20API18 view = new GLSurfaceView20API18(application.getContext(), resolutionStrategy);
            if (configChooser != null) {
                view.setEGLConfigChooser(configChooser);
            } else {
                view.setEGLConfigChooser(this.config.r, this.config.g, this.config.b, this.config.a, this.config.depth, this.config.stencil);
            }
            view.setRenderer(this);
            return view;
        }
        GLSurfaceView20 view = new GLSurfaceView20(application.getContext(), resolutionStrategy);
        if (configChooser != null) {
            view.setEGLConfigChooser(configChooser);
        } else {
            view.setEGLConfigChooser(this.config.r, this.config.g, this.config.b, this.config.a, this.config.depth, this.config.stencil);
        }
        view.setRenderer(this);
        return view;
    }

    public void onPauseGLSurfaceView() {
        if (this.view != null) {
            if (this.view instanceof GLSurfaceViewAPI18) {
                ((GLSurfaceViewAPI18)this.view).onPause();
            }
            if (this.view instanceof GLSurfaceView) {
                ((GLSurfaceView)this.view).onPause();
            }
        }
    }

    public void onResumeGLSurfaceView() {
        if (this.view != null) {
            if (this.view instanceof GLSurfaceViewAPI18) {
                ((GLSurfaceViewAPI18)this.view).onResume();
            }
            if (this.view instanceof GLSurfaceView) {
                ((GLSurfaceView)this.view).onResume();
            }
        }
    }

    protected GLSurfaceView.EGLConfigChooser getEglConfigChooser() {
        return new GdxEglConfigChooser(this.config.r, this.config.g, this.config.b, this.config.a, this.config.depth, this.config.stencil, this.config.numSamples);
    }

    private void updatePpi() {
        DisplayMetrics metrics = new DisplayMetrics();
        this.app.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        this.ppiX = metrics.xdpi;
        this.ppiY = metrics.ydpi;
        this.ppcX = metrics.xdpi / 2.54f;
        this.ppcY = metrics.ydpi / 2.54f;
        this.density = metrics.density;
    }

    protected boolean checkGL20() {
        EGL10 egl = (EGL10)EGLContext.getEGL();
        EGLDisplay display = egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        int[] version = new int[2];
        egl.eglInitialize(display, version);
        int EGL_OPENGL_ES2_BIT = 4;
        int[] configAttribs = new int[]{12324, 4, 12323, 4, 12322, 4, 12352, EGL_OPENGL_ES2_BIT, 12344};
        EGLConfig[] configs = new EGLConfig[10];
        int[] num_config = new int[1];
        egl.eglChooseConfig(display, configAttribs, configs, 10, num_config);
        egl.eglTerminate(display);
        return num_config[0] > 0;
    }

    public GL20 getGL20() {
        return this.gl20;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getBackBufferWidth() {
        return this.width;
    }

    public int getBackBufferHeight() {
        return this.height;
    }

    private void setupGL(GL10 gl) {
        if (this.gl20 != null) {
            return;
        }
        Gdx.gl = this.gl20 = new AndroidGL20();
        Gdx.gl20 = this.gl20;
        Gdx.app.log(LOG_TAG, "OGL renderer: " + gl.glGetString(7937));
        Gdx.app.log(LOG_TAG, "OGL vendor: " + gl.glGetString(7936));
        Gdx.app.log(LOG_TAG, "OGL version: " + gl.glGetString(7938));
        Gdx.app.log(LOG_TAG, "OGL extensions: " + gl.glGetString(7939));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceChanged(GL10 gl, int width, int height) {
        this.width = width;
        this.height = height;
        this.updatePpi();
        gl.glViewport(0, 0, this.width, this.height);
        if (!this.created) {
            this.app.getApplicationListener().create();
            this.created = true;
            AndroidGraphics androidGraphics = this;
            synchronized (androidGraphics) {
                this.running = true;
            }
        }
        this.app.getApplicationListener().resize(width, height);
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        this.eglContext = ((EGL10)EGLContext.getEGL()).eglGetCurrentContext();
        this.setupGL(gl);
        this.logConfig(config);
        this.updatePpi();
        Mesh.invalidateAllMeshes((Application)this.app);
        Texture.invalidateAllTextures((Application)this.app);
        Cubemap.invalidateAllCubemaps((Application)this.app);
        ShaderProgram.invalidateAllShaderPrograms((Application)this.app);
        FrameBuffer.invalidateAllFrameBuffers((Application)this.app);
        this.logManagedCachesStatus();
        Display display = this.app.getWindowManager().getDefaultDisplay();
        this.width = display.getWidth();
        this.height = display.getHeight();
        this.mean = new WindowedMean(5);
        this.lastFrameTime = System.nanoTime();
        gl.glViewport(0, 0, this.width, this.height);
    }

    private void logConfig(EGLConfig config) {
        EGL10 egl = (EGL10)EGLContext.getEGL();
        EGLDisplay display = egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        int r = this.getAttrib(egl, display, config, 12324, 0);
        int g = this.getAttrib(egl, display, config, 12323, 0);
        int b = this.getAttrib(egl, display, config, 12322, 0);
        int a = this.getAttrib(egl, display, config, 12321, 0);
        int d = this.getAttrib(egl, display, config, 12325, 0);
        int s = this.getAttrib(egl, display, config, 12326, 0);
        int samples = Math.max(this.getAttrib(egl, display, config, 12337, 0), this.getAttrib(egl, display, config, 12513, 0));
        boolean coverageSample = this.getAttrib(egl, display, config, 12513, 0) != 0;
        Gdx.app.log(LOG_TAG, "framebuffer: (" + r + ", " + g + ", " + b + ", " + a + ")");
        Gdx.app.log(LOG_TAG, "depthbuffer: (" + d + ")");
        Gdx.app.log(LOG_TAG, "stencilbuffer: (" + s + ")");
        Gdx.app.log(LOG_TAG, "samples: (" + samples + ")");
        Gdx.app.log(LOG_TAG, "coverage sampling: (" + coverageSample + ")");
        this.bufferFormat = new Graphics.BufferFormat(r, g, b, a, d, s, samples, coverageSample);
    }

    private int getAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attrib, int defValue) {
        if (egl.eglGetConfigAttrib(display, config, attrib, this.value)) {
            return this.value[0];
        }
        return defValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resume() {
        Object object = this.synch;
        synchronized (object) {
            this.running = true;
            this.resume = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pause() {
        Object object = this.synch;
        synchronized (object) {
            if (!this.running) {
                return;
            }
            this.running = false;
            this.pause = true;
            while (this.pause) {
                try {
                    this.synch.wait(4000L);
                    if (!this.pause) continue;
                    Gdx.app.error(LOG_TAG, "waiting for pause synchronization took too long; assuming deadlock and killing");
                    Process.killProcess((int)Process.myPid());
                }
                catch (InterruptedException ignored) {
                    Gdx.app.log(LOG_TAG, "waiting for pause synchronization failed!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        Object object = this.synch;
        synchronized (object) {
            this.running = false;
            this.destroy = true;
            while (this.destroy) {
                try {
                    this.synch.wait();
                }
                catch (InterruptedException ex) {
                    Gdx.app.log(LOG_TAG, "waiting for destroy synchronization failed!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDrawFrame(GL10 gl) {
        Array<LifecycleListener> array;
        Object listeners;
        long time = System.nanoTime();
        this.deltaTime = (float)(time - this.lastFrameTime) / 1.0E9f;
        this.lastFrameTime = time;
        if (!this.resume) {
            this.mean.addValue(this.deltaTime);
        } else {
            this.deltaTime = 0.0f;
        }
        boolean lrunning = false;
        boolean lpause = false;
        boolean ldestroy = false;
        boolean lresume = false;
        Object object = this.synch;
        synchronized (object) {
            lrunning = this.running;
            lpause = this.pause;
            ldestroy = this.destroy;
            lresume = this.resume;
            if (this.resume) {
                this.resume = false;
            }
            if (this.pause) {
                this.pause = false;
                this.synch.notifyAll();
            }
            if (this.destroy) {
                this.destroy = false;
                this.synch.notifyAll();
            }
        }
        if (lresume) {
            array = listeners = this.app.getLifecycleListeners();
            synchronized (array) {
                for (LifecycleListener listener : listeners) {
                    listener.resume();
                }
            }
            this.app.getApplicationListener().resume();
            Gdx.app.log(LOG_TAG, "resumed");
        }
        if (lrunning) {
            listeners = this.app.getRunnables();
            synchronized (listeners) {
                this.app.getExecutedRunnables().clear();
                this.app.getExecutedRunnables().addAll(this.app.getRunnables());
                this.app.getRunnables().clear();
            }
            for (int i = 0; i < this.app.getExecutedRunnables().size; ++i) {
                try {
                    ((Runnable)this.app.getExecutedRunnables().get(i)).run();
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            this.app.getInput().processEvents();
            ++this.frameId;
            this.app.getApplicationListener().render();
        }
        if (lpause) {
            Array<LifecycleListener> listeners2;
            array = listeners2 = this.app.getLifecycleListeners();
            synchronized (array) {
                for (LifecycleListener listener : listeners2) {
                    listener.pause();
                }
            }
            this.app.getApplicationListener().pause();
            Gdx.app.log(LOG_TAG, "paused");
        }
        if (ldestroy) {
            Array<LifecycleListener> listeners3;
            array = listeners3 = this.app.getLifecycleListeners();
            synchronized (array) {
                for (LifecycleListener listener : listeners3) {
                    listener.dispose();
                }
            }
            this.app.getApplicationListener().dispose();
            Gdx.app.log(LOG_TAG, "destroyed");
        }
        if (time - this.frameStart > 1000000000L) {
            this.fps = this.frames;
            this.frames = 0;
            this.frameStart = time;
        }
        ++this.frames;
    }

    public long getFrameId() {
        return this.frameId;
    }

    public float getDeltaTime() {
        return this.mean.getMean() == 0.0f ? this.deltaTime : this.mean.getMean();
    }

    public float getRawDeltaTime() {
        return this.deltaTime;
    }

    public Graphics.GraphicsType getType() {
        return Graphics.GraphicsType.AndroidGL;
    }

    public int getFramesPerSecond() {
        return this.fps;
    }

    public void clearManagedCaches() {
        Mesh.clearAllMeshes((Application)this.app);
        Texture.clearAllTextures((Application)this.app);
        Cubemap.clearAllCubemaps((Application)this.app);
        ShaderProgram.clearAllShaderPrograms((Application)this.app);
        FrameBuffer.clearAllFrameBuffers((Application)this.app);
        this.logManagedCachesStatus();
    }

    protected void logManagedCachesStatus() {
        Gdx.app.log(LOG_TAG, Mesh.getManagedStatus());
        Gdx.app.log(LOG_TAG, Texture.getManagedStatus());
        Gdx.app.log(LOG_TAG, Cubemap.getManagedStatus());
        Gdx.app.log(LOG_TAG, ShaderProgram.getManagedStatus());
        Gdx.app.log(LOG_TAG, FrameBuffer.getManagedStatus());
    }

    public View getView() {
        return this.view;
    }

    public float getPpiX() {
        return this.ppiX;
    }

    public float getPpiY() {
        return this.ppiY;
    }

    public float getPpcX() {
        return this.ppcX;
    }

    public float getPpcY() {
        return this.ppcY;
    }

    public float getDensity() {
        return this.density;
    }

    public boolean supportsDisplayModeChange() {
        return false;
    }

    public boolean setFullscreenMode(Graphics.DisplayMode displayMode) {
        return false;
    }

    public Graphics.Monitor getPrimaryMonitor() {
        return new AndroidMonitor(0, 0, "Primary Monitor");
    }

    public Graphics.Monitor getMonitor() {
        return this.getPrimaryMonitor();
    }

    public Graphics.Monitor[] getMonitors() {
        return new Graphics.Monitor[]{this.getPrimaryMonitor()};
    }

    public Graphics.DisplayMode[] getDisplayModes(Graphics.Monitor monitor) {
        return this.getDisplayModes();
    }

    public Graphics.DisplayMode getDisplayMode(Graphics.Monitor monitor) {
        return this.getDisplayMode();
    }

    public Graphics.DisplayMode[] getDisplayModes() {
        return new Graphics.DisplayMode[]{this.getDisplayMode()};
    }

    public boolean setWindowedMode(int width, int height) {
        return false;
    }

    public void setTitle(String title) {
    }

    public Graphics.DisplayMode getDisplayMode() {
        DisplayMetrics metrics = new DisplayMetrics();
        this.app.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        return new AndroidDisplayMode(metrics.widthPixels, metrics.heightPixels, 0, 0);
    }

    public Graphics.BufferFormat getBufferFormat() {
        return this.bufferFormat;
    }

    public void setVSync(boolean vsync) {
    }

    public boolean supportsExtension(String extension) {
        if (this.extensions == null) {
            this.extensions = Gdx.gl.glGetString(7939);
        }
        return this.extensions.contains(extension);
    }

    public void setContinuousRendering(boolean isContinuous) {
        if (this.view != null) {
            int renderMode;
            this.isContinuous = enforceContinuousRendering || isContinuous;
            int n = renderMode = this.isContinuous ? 1 : 0;
            if (this.view instanceof GLSurfaceViewAPI18) {
                ((GLSurfaceViewAPI18)this.view).setRenderMode(renderMode);
            }
            if (this.view instanceof GLSurfaceView) {
                ((GLSurfaceView)this.view).setRenderMode(renderMode);
            }
            this.mean.clear();
        }
    }

    public boolean isContinuousRendering() {
        return this.isContinuous;
    }

    public void requestRendering() {
        if (this.view != null) {
            if (this.view instanceof GLSurfaceViewAPI18) {
                ((GLSurfaceViewAPI18)this.view).requestRender();
            }
            if (this.view instanceof GLSurfaceView) {
                ((GLSurfaceView)this.view).requestRender();
            }
        }
    }

    public boolean isFullscreen() {
        return true;
    }

    public boolean isGL30Available() {
        return this.gl30 != null;
    }

    public GL30 getGL30() {
        return this.gl30;
    }

    public Cursor newCursor(Pixmap pixmap, int xHotspot, int yHotspot) {
        return null;
    }

    public void setCursor(Cursor cursor) {
    }

    public void setSystemCursor(Cursor.SystemCursor systemCursor) {
    }

    private class AndroidMonitor
    extends Graphics.Monitor {
        public AndroidMonitor(int virtualX, int virtualY, String name) {
            super(virtualX, virtualY, name);
        }
    }

    private class AndroidDisplayMode
    extends Graphics.DisplayMode {
        protected AndroidDisplayMode(int width, int height, int refreshRate, int bitsPerPixel) {
            super(width, height, refreshRate, bitsPerPixel);
        }
    }
}

