/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.os.Build;
import com.badlogic.gdx.utils.Clipboard;

public class AndroidClipboard
implements Clipboard {
    Context context;

    public AndroidClipboard(Context context) {
        this.context = context;
    }

    public String getContents() {
        if (Build.VERSION.SDK_INT < 11) {
            android.text.ClipboardManager clipboard = (android.text.ClipboardManager)this.context.getSystemService("clipboard");
            if (clipboard.getText() == null) {
                return null;
            }
            return clipboard.getText().toString();
        }
        ClipboardManager clipboard = (ClipboardManager)this.context.getSystemService("clipboard");
        ClipData clip = clipboard.getPrimaryClip();
        if (clip == null) {
            return null;
        }
        CharSequence text = clip.getItemAt(0).getText();
        if (text == null) {
            return null;
        }
        return text.toString();
    }

    public void setContents(final String contents) {
        try {
            ((Activity)this.context).runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (Build.VERSION.SDK_INT < 11) {
                        android.text.ClipboardManager clipboard = (android.text.ClipboardManager)AndroidClipboard.this.context.getSystemService("clipboard");
                        clipboard.setText((CharSequence)contents);
                    } else {
                        ClipboardManager clipboard = (ClipboardManager)AndroidClipboard.this.context.getSystemService("clipboard");
                        ClipData data = ClipData.newPlainText((CharSequence)contents, (CharSequence)contents);
                        clipboard.setPrimaryClip(data);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

