/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.SoundPool;
import com.badlogic.gdx.Audio;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.audio.AudioDevice;
import com.badlogic.gdx.audio.AudioRecorder;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.backends.android.AndroidApplicationConfiguration;
import com.badlogic.gdx.backends.android.AndroidAudioDevice;
import com.badlogic.gdx.backends.android.AndroidAudioRecorder;
import com.badlogic.gdx.backends.android.AndroidFileHandle;
import com.badlogic.gdx.backends.android.AndroidMusic;
import com.badlogic.gdx.backends.android.AndroidSound;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class AndroidAudio
implements Audio {
    private final SoundPool soundPool;
    private final AudioManager manager;
    protected final List<AndroidMusic> musics = new ArrayList<AndroidMusic>();

    public AndroidAudio(Context context, AndroidApplicationConfiguration config) {
        if (!config.disableAudio) {
            this.soundPool = new SoundPool(config.maxSimultaneousSounds, 3, 100);
            this.manager = (AudioManager)context.getSystemService("audio");
            if (context instanceof Activity) {
                ((Activity)context).setVolumeControlStream(3);
            }
        } else {
            this.soundPool = null;
            this.manager = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pause() {
        if (this.soundPool == null) {
            return;
        }
        List<AndroidMusic> list = this.musics;
        synchronized (list) {
            for (AndroidMusic music : this.musics) {
                if (music.isPlaying()) {
                    music.pause();
                    music.wasPlaying = true;
                    continue;
                }
                music.wasPlaying = false;
            }
        }
        this.soundPool.autoPause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resume() {
        if (this.soundPool == null) {
            return;
        }
        List<AndroidMusic> list = this.musics;
        synchronized (list) {
            for (int i = 0; i < this.musics.size(); ++i) {
                if (!this.musics.get((int)i).wasPlaying) continue;
                this.musics.get(i).play();
            }
        }
        this.soundPool.autoResume();
    }

    public AudioDevice newAudioDevice(int samplingRate, boolean isMono) {
        if (this.soundPool == null) {
            throw new GdxRuntimeException("Android audio is not enabled by the application config.");
        }
        return new AndroidAudioDevice(samplingRate, isMono);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Music newMusic(FileHandle file) {
        if (this.soundPool == null) {
            throw new GdxRuntimeException("Android audio is not enabled by the application config.");
        }
        AndroidFileHandle aHandle = (AndroidFileHandle)file;
        MediaPlayer mediaPlayer = new MediaPlayer();
        if (aHandle.type() == Files.FileType.Internal) {
            try {
                AssetFileDescriptor descriptor = aHandle.assets.openFd(aHandle.path());
                mediaPlayer.setDataSource(descriptor.getFileDescriptor(), descriptor.getStartOffset(), descriptor.getLength());
                descriptor.close();
                mediaPlayer.prepare();
                AndroidMusic music = new AndroidMusic(this, mediaPlayer);
                List<AndroidMusic> list = this.musics;
                synchronized (list) {
                    this.musics.add(music);
                }
                return music;
            }
            catch (Exception ex) {
                throw new GdxRuntimeException("Error loading audio file: " + file + "\nNote: Internal audio files must be placed in the assets directory.", (Throwable)ex);
            }
        }
        try {
            mediaPlayer.setDataSource(aHandle.file().getPath());
            mediaPlayer.prepare();
            AndroidMusic music = new AndroidMusic(this, mediaPlayer);
            List<AndroidMusic> list = this.musics;
            synchronized (list) {
                this.musics.add(music);
            }
            return music;
        }
        catch (Exception ex) {
            throw new GdxRuntimeException("Error loading audio file: " + file, (Throwable)ex);
        }
    }

    public Sound newSound(FileHandle file) {
        if (this.soundPool == null) {
            throw new GdxRuntimeException("Android audio is not enabled by the application config.");
        }
        AndroidFileHandle aHandle = (AndroidFileHandle)file;
        if (aHandle.type() == Files.FileType.Internal) {
            try {
                AssetFileDescriptor descriptor = aHandle.assets.openFd(aHandle.path());
                AndroidSound sound = new AndroidSound(this.soundPool, this.manager, this.soundPool.load(descriptor, 1));
                descriptor.close();
                return sound;
            }
            catch (IOException ex) {
                throw new GdxRuntimeException("Error loading audio file: " + file + "\nNote: Internal audio files must be placed in the assets directory.", (Throwable)ex);
            }
        }
        try {
            return new AndroidSound(this.soundPool, this.manager, this.soundPool.load(aHandle.file().getPath(), 1));
        }
        catch (Exception ex) {
            throw new GdxRuntimeException("Error loading audio file: " + file, (Throwable)ex);
        }
    }

    public AudioRecorder newAudioRecorder(int samplingRate, boolean isMono) {
        if (this.soundPool == null) {
            throw new GdxRuntimeException("Android audio is not enabled by the application config.");
        }
        return new AndroidAudioRecorder(samplingRate, isMono);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.soundPool == null) {
            return;
        }
        List<AndroidMusic> list = this.musics;
        synchronized (list) {
            ArrayList<AndroidMusic> musicsCopy = new ArrayList<AndroidMusic>(this.musics);
            for (AndroidMusic music : musicsCopy) {
                music.dispose();
            }
        }
        this.soundPool.release();
    }
}

