/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.content.res.AssetFileDescriptor;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.android.AndroidFileHandle;
import com.badlogic.gdx.backends.android.AndroidFiles;
import com.badlogic.gdx.backends.android.ZipResourceFile;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;

public class AndroidZipFileHandle
extends AndroidFileHandle {
    private boolean hasAssetFd;
    private long fdLength;
    private ZipResourceFile expansionFile;
    private String path;

    public AndroidZipFileHandle(String fileName) {
        super(null, fileName, Files.FileType.Internal);
        this.initialize();
    }

    public AndroidZipFileHandle(File file, Files.FileType type) {
        super(null, file, type);
        this.initialize();
    }

    private void initialize() {
        this.path = this.file.getPath().replace('\\', '/');
        this.expansionFile = ((AndroidFiles)Gdx.files).getExpansionFile();
        AssetFileDescriptor assetFd = this.expansionFile.getAssetFileDescriptor(this.getPath());
        if (assetFd != null) {
            this.hasAssetFd = true;
            this.fdLength = assetFd.getLength();
            try {
                assetFd.close();
            }
            catch (IOException iOException) {}
        } else {
            this.hasAssetFd = false;
        }
        if (this.isDirectory()) {
            this.path = this.path + "/";
        }
    }

    @Override
    public AssetFileDescriptor getAssetFileDescriptor() throws IOException {
        return this.expansionFile.getAssetFileDescriptor(this.getPath());
    }

    private String getPath() {
        return this.path;
    }

    @Override
    public InputStream read() {
        InputStream input = null;
        try {
            input = this.expansionFile.getInputStream(this.getPath());
        }
        catch (IOException ex) {
            throw new GdxRuntimeException("Error reading file: " + this.file + " (ZipResourceFile)", (Throwable)ex);
        }
        return input;
    }

    @Override
    public FileHandle child(String name) {
        if (this.file.getPath().length() == 0) {
            return new AndroidZipFileHandle(new File(name), this.type);
        }
        return new AndroidZipFileHandle(new File(this.file, name), this.type);
    }

    @Override
    public FileHandle sibling(String name) {
        if (this.file.getPath().length() == 0) {
            throw new GdxRuntimeException("Cannot get the sibling of the root.");
        }
        return Gdx.files.getFileHandle(new File(this.file.getParent(), name).getPath(), this.type);
    }

    @Override
    public FileHandle parent() {
        File parent = this.file.getParentFile();
        if (parent == null) {
            parent = new File("");
        }
        return new AndroidZipFileHandle(parent.getPath());
    }

    @Override
    public FileHandle[] list() {
        ZipResourceFile.ZipEntryRO[] zipEntries = this.expansionFile.getEntriesAt(this.getPath());
        FileHandle[] handles = new FileHandle[zipEntries.length - 1];
        int count = 0;
        int n = zipEntries.length;
        for (int i = 0; i < n; ++i) {
            if (zipEntries[i].mFileName.length() == this.getPath().length()) continue;
            handles[count++] = new AndroidZipFileHandle(zipEntries[i].mFileName);
        }
        return handles;
    }

    @Override
    public FileHandle[] list(FileFilter filter) {
        ZipResourceFile.ZipEntryRO[] zipEntries = this.expansionFile.getEntriesAt(this.getPath());
        FileHandle[] handles = new FileHandle[zipEntries.length - 1];
        int count = 0;
        int n = zipEntries.length;
        for (int i = 0; i < n; ++i) {
            AndroidZipFileHandle child;
            if (zipEntries[i].mFileName.length() == this.getPath().length() || !filter.accept((child = new AndroidZipFileHandle(zipEntries[i].mFileName)).file())) continue;
            handles[count] = child;
            ++count;
        }
        if (count < handles.length) {
            FileHandle[] newHandles = new FileHandle[count];
            System.arraycopy(handles, 0, newHandles, 0, count);
            handles = newHandles;
        }
        return handles;
    }

    @Override
    public FileHandle[] list(FilenameFilter filter) {
        ZipResourceFile.ZipEntryRO[] zipEntries = this.expansionFile.getEntriesAt(this.getPath());
        FileHandle[] handles = new FileHandle[zipEntries.length - 1];
        int count = 0;
        int n = zipEntries.length;
        for (int i = 0; i < n; ++i) {
            String path;
            if (zipEntries[i].mFileName.length() == this.getPath().length() || !filter.accept(this.file, path = zipEntries[i].mFileName)) continue;
            handles[count] = new AndroidZipFileHandle(path);
            ++count;
        }
        if (count < handles.length) {
            FileHandle[] newHandles = new FileHandle[count];
            System.arraycopy(handles, 0, newHandles, 0, count);
            handles = newHandles;
        }
        return handles;
    }

    @Override
    public FileHandle[] list(String suffix) {
        ZipResourceFile.ZipEntryRO[] zipEntries = this.expansionFile.getEntriesAt(this.getPath());
        FileHandle[] handles = new FileHandle[zipEntries.length - 1];
        int count = 0;
        int n = zipEntries.length;
        for (int i = 0; i < n; ++i) {
            String path;
            if (zipEntries[i].mFileName.length() == this.getPath().length() || !(path = zipEntries[i].mFileName).endsWith(suffix)) continue;
            handles[count] = new AndroidZipFileHandle(path);
            ++count;
        }
        if (count < handles.length) {
            FileHandle[] newHandles = new FileHandle[count];
            System.arraycopy(handles, 0, newHandles, 0, count);
            handles = newHandles;
        }
        return handles;
    }

    @Override
    public boolean isDirectory() {
        return !this.hasAssetFd;
    }

    @Override
    public long length() {
        return this.hasAssetFd ? this.fdLength : 0L;
    }

    @Override
    public boolean exists() {
        return this.hasAssetFd || this.expansionFile.getEntriesAt(this.getPath()).length != 0;
    }
}

