/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.AudioAttributes;
import android.os.Build;
import android.os.VibrationEffect;
import android.os.Vibrator;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.math.MathUtils;

public class AndroidHaptics {
    private final Vibrator vibrator;
    private AudioAttributes audioAttributes;
    private boolean vibratorSupport = false;
    private boolean hapticsSupport = false;

    public AndroidHaptics(Context context) {
        this.vibrator = (Vibrator)context.getSystemService("vibrator");
        if (this.vibrator != null && this.vibrator.hasVibrator()) {
            this.vibratorSupport = true;
            if (Build.VERSION.SDK_INT >= 29) {
                if (this.vibrator.hasAmplitudeControl()) {
                    this.hapticsSupport = true;
                }
                this.audioAttributes = new AudioAttributes.Builder().setContentType(4).setUsage(14).build();
            }
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public void vibrate(int milliseconds) {
        if (this.vibratorSupport) {
            if (Build.VERSION.SDK_INT >= 26) {
                this.vibrator.vibrate(VibrationEffect.createOneShot((long)milliseconds, (int)-1));
            } else {
                this.vibrator.vibrate((long)milliseconds);
            }
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public void vibrate(Input.VibrationType vibrationType) {
        if (this.hapticsSupport && Build.VERSION.SDK_INT >= 29) {
            int vibrationEffect;
            switch (vibrationType) {
                case LIGHT: {
                    vibrationEffect = 2;
                    break;
                }
                case MEDIUM: {
                    vibrationEffect = 0;
                    break;
                }
                case HEAVY: {
                    vibrationEffect = 5;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown VibrationType " + vibrationType);
                }
            }
            this.vibrator.vibrate(VibrationEffect.createPredefined((int)vibrationEffect), this.audioAttributes);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public void vibrate(int milliseconds, int intensity, boolean fallback) {
        if (this.hapticsSupport) {
            intensity = MathUtils.clamp((int)intensity, (int)0, (int)255);
            if (Build.VERSION.SDK_INT >= 26) {
                this.vibrator.vibrate(VibrationEffect.createOneShot((long)milliseconds, (int)intensity));
            }
        } else if (fallback) {
            this.vibrate(milliseconds);
        }
    }

    public boolean hasVibratorAvailable() {
        return this.vibratorSupport;
    }

    public boolean hasHapticsSupport() {
        return this.hapticsSupport;
    }
}

