/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.content.Context;
import android.os.Build;
import android.view.PointerIcon;
import android.view.View;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class AndroidCursor
implements Cursor {
    static void setSystemCursor(View view, Cursor.SystemCursor systemCursor) {
        if (Build.VERSION.SDK_INT >= 24) {
            int type;
            switch (systemCursor) {
                case Arrow: {
                    type = 1000;
                    break;
                }
                case Ibeam: {
                    type = 1008;
                    break;
                }
                case Crosshair: {
                    type = 1007;
                    break;
                }
                case Hand: {
                    type = 1002;
                    break;
                }
                case HorizontalResize: {
                    type = 1014;
                    break;
                }
                case VerticalResize: {
                    type = 1015;
                    break;
                }
                case NWSEResize: {
                    type = 1017;
                    break;
                }
                case NESWResize: {
                    type = 1016;
                    break;
                }
                case AllResize: {
                    type = 1013;
                    break;
                }
                case NotAllowed: {
                    type = 1012;
                    break;
                }
                case None: {
                    type = 0;
                    break;
                }
                default: {
                    throw new GdxRuntimeException("Unknown system cursor " + systemCursor);
                }
            }
            view.setPointerIcon(PointerIcon.getSystemIcon((Context)view.getContext(), (int)type));
        }
    }

    public void dispose() {
    }
}

