/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.media.AudioTrack;
import com.badlogic.gdx.audio.AudioDevice;

class AndroidAudioDevice
implements AudioDevice {
    private final AudioTrack track;
    private short[] buffer = new short[1024];
    private final boolean isMono;
    private final int latency;

    AndroidAudioDevice(int samplingRate, boolean isMono) {
        this.isMono = isMono;
        int minSize = AudioTrack.getMinBufferSize((int)samplingRate, (int)(isMono ? 4 : 12), (int)2);
        this.track = new AudioTrack(3, samplingRate, isMono ? 4 : 12, 2, minSize, 1);
        this.track.play();
        this.latency = minSize / (isMono ? 1 : 2);
    }

    public void dispose() {
        this.track.stop();
        this.track.release();
    }

    public boolean isMono() {
        return this.isMono;
    }

    public void writeSamples(short[] samples, int offset, int numSamples) {
        for (int writtenSamples = this.track.write(samples, offset, numSamples); writtenSamples != numSamples; writtenSamples += this.track.write(samples, offset + writtenSamples, numSamples - writtenSamples)) {
        }
    }

    public void writeSamples(float[] samples, int offset, int numSamples) {
        if (this.buffer.length < samples.length) {
            this.buffer = new short[samples.length];
        }
        int bound = offset + numSamples;
        int i = offset;
        int j = 0;
        while (i < bound) {
            short value;
            float fValue = samples[i];
            if (fValue > 1.0f) {
                fValue = 1.0f;
            }
            if (fValue < -1.0f) {
                fValue = -1.0f;
            }
            this.buffer[j] = value = (short)(fValue * 32767.0f);
            ++i;
            ++j;
        }
        for (int writtenSamples = this.track.write(this.buffer, 0, numSamples); writtenSamples != numSamples; writtenSamples += this.track.write(this.buffer, writtenSamples, numSamples - writtenSamples)) {
        }
    }

    public int getLatency() {
        return this.latency;
    }

    public void setVolume(float volume) {
        this.track.setStereoVolume(volume, volume);
    }

    public void pause() {
        if (this.track.getPlayState() == 3) {
            this.track.pause();
        }
    }

    public void resume() {
        if (this.track.getPlayState() == 2) {
            this.track.play();
        }
    }
}

