/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.SoundPool;
import android.os.Build;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.audio.AudioDevice;
import com.badlogic.gdx.audio.AudioRecorder;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.backends.android.AndroidApplicationConfiguration;
import com.badlogic.gdx.backends.android.AndroidAudio;
import com.badlogic.gdx.backends.android.AndroidAudioDevice;
import com.badlogic.gdx.backends.android.AndroidAudioRecorder;
import com.badlogic.gdx.backends.android.AndroidFileHandle;
import com.badlogic.gdx.backends.android.AndroidMusic;
import com.badlogic.gdx.backends.android.AndroidSound;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DefaultAndroidAudio
implements AndroidAudio {
    private final SoundPool soundPool;
    private final AudioManager manager;
    private final List<AndroidMusic> musics = new ArrayList<AndroidMusic>();

    public DefaultAndroidAudio(Context context, AndroidApplicationConfiguration config) {
        if (!config.disableAudio) {
            if (Build.VERSION.SDK_INT >= 21) {
                AudioAttributes audioAttrib = new AudioAttributes.Builder().setUsage(14).setContentType(4).build();
                this.soundPool = new SoundPool.Builder().setAudioAttributes(audioAttrib).setMaxStreams(config.maxSimultaneousSounds).build();
            } else {
                this.soundPool = new SoundPool(config.maxSimultaneousSounds, 3, 0);
            }
            this.manager = (AudioManager)context.getSystemService("audio");
            if (context instanceof Activity) {
                ((Activity)context).setVolumeControlStream(3);
            }
        } else {
            this.soundPool = null;
            this.manager = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        if (this.soundPool == null) {
            return;
        }
        List<AndroidMusic> list = this.musics;
        synchronized (list) {
            for (AndroidMusic music : this.musics) {
                if (music.isPlaying()) {
                    music.pause();
                    music.wasPlaying = true;
                    continue;
                }
                music.wasPlaying = false;
            }
        }
        this.soundPool.autoPause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        if (this.soundPool == null) {
            return;
        }
        List<AndroidMusic> list = this.musics;
        synchronized (list) {
            for (int i = 0; i < this.musics.size(); ++i) {
                if (!this.musics.get((int)i).wasPlaying) continue;
                this.musics.get(i).play();
            }
        }
        this.soundPool.autoResume();
    }

    public AudioDevice newAudioDevice(int samplingRate, boolean isMono) {
        if (this.soundPool == null) {
            throw new GdxRuntimeException("Android audio is not enabled by the application config.");
        }
        return new AndroidAudioDevice(samplingRate, isMono);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Music newMusic(FileHandle file) {
        if (this.soundPool == null) {
            throw new GdxRuntimeException("Android audio is not enabled by the application config.");
        }
        AndroidFileHandle aHandle = (AndroidFileHandle)file;
        MediaPlayer mediaPlayer = this.createMediaPlayer();
        if (aHandle.type() == Files.FileType.Internal) {
            try {
                AssetFileDescriptor descriptor = aHandle.getAssetFileDescriptor();
                mediaPlayer.setDataSource(descriptor.getFileDescriptor(), descriptor.getStartOffset(), descriptor.getLength());
                descriptor.close();
                mediaPlayer.prepare();
                AndroidMusic music = new AndroidMusic(this, mediaPlayer);
                List<AndroidMusic> list = this.musics;
                synchronized (list) {
                    this.musics.add(music);
                }
                return music;
            }
            catch (Exception ex) {
                throw new GdxRuntimeException("Error loading audio file: " + file + "\nNote: Internal audio files must be placed in the assets directory.", (Throwable)ex);
            }
        }
        try {
            mediaPlayer.setDataSource(aHandle.file().getPath());
            mediaPlayer.prepare();
            AndroidMusic music = new AndroidMusic(this, mediaPlayer);
            List<AndroidMusic> list = this.musics;
            synchronized (list) {
                this.musics.add(music);
            }
            return music;
        }
        catch (Exception ex) {
            throw new GdxRuntimeException("Error loading audio file: " + file, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Music newMusic(FileDescriptor fd) {
        if (this.soundPool == null) {
            throw new GdxRuntimeException("Android audio is not enabled by the application config.");
        }
        MediaPlayer mediaPlayer = this.createMediaPlayer();
        try {
            mediaPlayer.setDataSource(fd);
            mediaPlayer.prepare();
            AndroidMusic music = new AndroidMusic(this, mediaPlayer);
            List<AndroidMusic> list = this.musics;
            synchronized (list) {
                this.musics.add(music);
            }
            return music;
        }
        catch (Exception ex) {
            throw new GdxRuntimeException("Error loading audio from FileDescriptor", (Throwable)ex);
        }
    }

    public Sound newSound(FileHandle file) {
        AndroidSound androidSound;
        if (this.soundPool == null) {
            throw new GdxRuntimeException("Android audio is not enabled by the application config.");
        }
        AndroidFileHandle aHandle = (AndroidFileHandle)file;
        if (aHandle.type() == Files.FileType.Internal) {
            try {
                AssetFileDescriptor descriptor = aHandle.getAssetFileDescriptor();
                androidSound = new AndroidSound(this.soundPool, this.manager, this.soundPool.load(descriptor, 1));
                descriptor.close();
            }
            catch (IOException ex) {
                throw new GdxRuntimeException("Error loading audio file: " + file + "\nNote: Internal audio files must be placed in the assets directory.", (Throwable)ex);
            }
        }
        try {
            androidSound = new AndroidSound(this.soundPool, this.manager, this.soundPool.load(aHandle.file().getPath(), 1));
        }
        catch (Exception ex) {
            throw new GdxRuntimeException("Error loading audio file: " + file, (Throwable)ex);
        }
        return androidSound;
    }

    public AudioRecorder newAudioRecorder(int samplingRate, boolean isMono) {
        if (this.soundPool == null) {
            throw new GdxRuntimeException("Android audio is not enabled by the application config.");
        }
        return new AndroidAudioRecorder(samplingRate, isMono);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.soundPool == null) {
            return;
        }
        List<AndroidMusic> list = this.musics;
        synchronized (list) {
            ArrayList<AndroidMusic> musicsCopy = new ArrayList<AndroidMusic>(this.musics);
            for (AndroidMusic music : musicsCopy) {
                music.dispose();
            }
        }
        this.soundPool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyMusicDisposed(AndroidMusic music) {
        List<AndroidMusic> list = this.musics;
        synchronized (list) {
            this.musics.remove(this);
        }
    }

    protected MediaPlayer createMediaPlayer() {
        MediaPlayer mediaPlayer = new MediaPlayer();
        if (Build.VERSION.SDK_INT <= 21) {
            mediaPlayer.setAudioStreamType(3);
        } else {
            mediaPlayer.setAudioAttributes(new AudioAttributes.Builder().setContentType(2).setUsage(14).build());
        }
        return mediaPlayer;
    }
}

