/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android.surfaceview;

import android.view.View;
import com.badlogic.gdx.backends.android.surfaceview.ResolutionStrategy;

public class RatioResolutionStrategy
implements ResolutionStrategy {
    private final float ratio;

    public RatioResolutionStrategy(float ratio) {
        this.ratio = ratio;
    }

    public RatioResolutionStrategy(float width, float height) {
        this.ratio = width / height;
    }

    @Override
    public ResolutionStrategy.MeasuredDimension calcMeasures(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int width;
        float desiredRatio;
        int specHeight;
        int specWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        float realRatio = (float)specWidth / (float)(specHeight = View.MeasureSpec.getSize((int)heightMeasureSpec));
        if (realRatio < (desiredRatio = this.ratio)) {
            width = specWidth;
            height = Math.round((float)width / desiredRatio);
        } else {
            height = specHeight;
            width = Math.round((float)height * desiredRatio);
        }
        return new ResolutionStrategy.MeasuredDimension(width, height);
    }
}

