/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.content.Context;
import android.view.MotionEvent;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.android.AndroidInput;
import com.badlogic.gdx.backends.android.AndroidTouchHandler;

public class AndroidSingleTouchHandler
implements AndroidTouchHandler {
    @Override
    public void onTouch(MotionEvent event, AndroidInput input) {
        int x = (int)event.getX();
        int y = (int)event.getY();
        int oldX = input.touchX[0];
        int oldY = input.touchY[0];
        input.touchX[0] = x;
        input.touchY[0] = y;
        long timeStamp = event.getEventTime() * 1000000L;
        if (event.getAction() == 0) {
            this.postTouchEvent(input, 0, x, y, 0, timeStamp);
            input.touched[0] = true;
            input.deltaX[0] = 0;
            input.deltaY[0] = 0;
        } else if (event.getAction() == 2) {
            this.postTouchEvent(input, 2, x, y, 0, timeStamp);
            input.touched[0] = true;
            input.deltaX[0] = x - oldX;
            input.deltaY[0] = y - oldY;
        } else if (event.getAction() == 1) {
            this.postTouchEvent(input, 1, x, y, 0, timeStamp);
            input.touched[0] = false;
            input.deltaX[0] = 0;
            input.deltaY[0] = 0;
        } else if (event.getAction() == 3) {
            this.postTouchEvent(input, 1, x, y, 0, timeStamp);
            input.touched[0] = false;
            input.deltaX[0] = 0;
            input.deltaY[0] = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postTouchEvent(AndroidInput input, int type, int x, int y, int pointer, long timeStamp) {
        AndroidInput androidInput = input;
        synchronized (androidInput) {
            AndroidInput.TouchEvent event = (AndroidInput.TouchEvent)input.usedTouchEvents.obtain();
            event.timeStamp = timeStamp;
            event.pointer = 0;
            event.x = x;
            event.y = y;
            event.type = type;
            input.touchEvents.add(event);
        }
        Gdx.app.getGraphics().requestRendering();
    }

    @Override
    public boolean supportsMultitouch(Context activity) {
        return false;
    }
}

