/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.os.Debug;
import android.util.Log;
import android.view.WindowManager;
import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Audio;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.backends.android.AndroidApplicationConfiguration;
import com.badlogic.gdx.backends.android.AndroidAudio;
import com.badlogic.gdx.backends.android.AndroidClipboard;
import com.badlogic.gdx.backends.android.AndroidFiles;
import com.badlogic.gdx.backends.android.AndroidGraphicsLiveWallpaper;
import com.badlogic.gdx.backends.android.AndroidInput;
import com.badlogic.gdx.backends.android.AndroidInputFactory;
import com.badlogic.gdx.backends.android.AndroidLiveWallpaperService;
import com.badlogic.gdx.backends.android.AndroidNet;
import com.badlogic.gdx.backends.android.AndroidPreferences;
import com.badlogic.gdx.backends.android.surfaceview.FillResolutionStrategy;
import com.badlogic.gdx.backends.android.surfaceview.GLSurfaceViewAPI18;
import com.badlogic.gdx.backends.android.surfaceview.GLSurfaceViewCupcake;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Clipboard;
import com.badlogic.gdx.utils.GdxNativesLoader;
import java.lang.reflect.Method;

public class AndroidLiveWallpaper
implements Application {
    protected AndroidLiveWallpaperService service;
    protected AndroidGraphicsLiveWallpaper graphics;
    protected AndroidInput input;
    protected AndroidAudio audio;
    protected AndroidFiles files;
    protected AndroidNet net;
    protected ApplicationListener listener;
    protected boolean firstResume = true;
    protected final Array<Runnable> runnables = new Array();
    protected final Array<Runnable> executedRunnables = new Array();
    protected final Array<LifecycleListener> lifecycleListeners = new Array();
    protected int logLevel = 2;
    AndroidClipboard clipboard;

    public AndroidLiveWallpaper(AndroidLiveWallpaperService service) {
        this.service = service;
    }

    public void initialize(ApplicationListener listener, AndroidApplicationConfiguration config) {
        this.graphics = new AndroidGraphicsLiveWallpaper(this, config, config.resolutionStrategy == null ? new FillResolutionStrategy() : config.resolutionStrategy);
        this.input = AndroidInputFactory.newAndroidInput(this, (Context)this.getService(), this.graphics.view, config);
        this.audio = new AndroidAudio((Context)this.getService(), config);
        this.files = new AndroidFiles(this.getService().getAssets(), this.getService().getFilesDir().getAbsolutePath());
        this.listener = listener;
        Gdx.app = this;
        Gdx.input = this.input;
        Gdx.audio = this.audio;
        Gdx.files = this.files;
        Gdx.graphics = this.graphics;
    }

    public void onPause() {
        if (AndroidLiveWallpaperService.DEBUG) {
            Log.d((String)"WallpaperService", (String)" > AndroidLiveWallpaper - onPause()");
        }
        this.audio.pause();
        this.input.unregisterSensorListeners();
        int[] realId = this.input.realId;
        for (int i = 0; i < realId.length; ++i) {
            realId[i] = -1;
        }
        boolean[] touched = this.input.touched;
        for (int i = 0; i < touched.length; ++i) {
            touched[i] = false;
        }
        if (this.graphics != null && this.graphics.view != null) {
            if (this.graphics.view instanceof GLSurfaceViewCupcake) {
                ((GLSurfaceViewCupcake)this.graphics.view).onPause();
            } else if (this.graphics.view instanceof GLSurfaceViewAPI18) {
                ((GLSurfaceViewAPI18)this.graphics.view).onPause();
            } else if (this.graphics.view instanceof GLSurfaceView) {
                ((GLSurfaceView)this.graphics.view).onPause();
            } else {
                throw new RuntimeException("unimplemented");
            }
        }
        if (AndroidLiveWallpaperService.DEBUG) {
            Log.d((String)"WallpaperService", (String)" > AndroidLiveWallpaper - onPause() done!");
        }
    }

    public void onResume() {
        Gdx.app = this;
        Gdx.input = this.input;
        Gdx.audio = this.audio;
        Gdx.files = this.files;
        Gdx.graphics = this.graphics;
        this.input.registerSensorListeners();
        if (this.graphics != null && this.graphics.view != null) {
            if (this.graphics.view instanceof GLSurfaceViewCupcake) {
                ((GLSurfaceViewCupcake)this.graphics.view).onResume();
            } else if (this.graphics.view instanceof GLSurfaceViewAPI18) {
                ((GLSurfaceViewAPI18)this.graphics.view).onResume();
            } else if (this.graphics.view instanceof GLSurfaceView) {
                ((GLSurfaceView)this.graphics.view).onResume();
            } else {
                throw new RuntimeException("unimplemented");
            }
        }
        if (!this.firstResume) {
            this.audio.resume();
            this.graphics.resume();
        } else {
            this.firstResume = false;
        }
    }

    public void onDestroy() {
        block7: {
            if (this.graphics != null && this.graphics.view != null && this.graphics.view instanceof GLSurfaceView) {
                GLSurfaceView glSurfaceView = (GLSurfaceView)this.graphics.view;
                try {
                    Method method = null;
                    for (Method m : glSurfaceView.getClass().getMethods()) {
                        if (!m.getName().equals("onDestroy")) continue;
                        method = m;
                        break;
                    }
                    if (method != null) {
                        method.invoke((Object)glSurfaceView, new Object[0]);
                        if (AndroidLiveWallpaperService.DEBUG) {
                            Log.d((String)"WallpaperService", (String)" > AndroidLiveWallpaper - onDestroy() stopped GLThread managed by GLSurfaceView");
                        }
                        break block7;
                    }
                    throw new Exception("method not found!");
                }
                catch (Throwable t) {
                    Log.e((String)"WallpaperService", (String)"failed to destroy GLSurfaceView's thread! GLSurfaceView.onDetachedFromWindow impl changed since API lvl 16!");
                    t.printStackTrace();
                }
            }
        }
        if (this.audio != null) {
            this.audio.dispose();
        }
    }

    public WindowManager getWindowManager() {
        return this.service.getWindowManager();
    }

    public AndroidLiveWallpaperService getService() {
        return this.service;
    }

    public ApplicationListener getListener() {
        return this.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRunnable(Runnable runnable) {
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            this.runnables.add((Object)runnable);
        }
    }

    public Audio getAudio() {
        return this.audio;
    }

    public Files getFiles() {
        return this.files;
    }

    public Graphics getGraphics() {
        return this.graphics;
    }

    public Input getInput() {
        return this.input;
    }

    public Net getNet() {
        return this.net;
    }

    public Application.ApplicationType getType() {
        return Application.ApplicationType.Android;
    }

    public int getVersion() {
        return Integer.parseInt(Build.VERSION.SDK);
    }

    public long getJavaHeap() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public long getNativeHeap() {
        return Debug.getNativeHeapAllocatedSize();
    }

    public Preferences getPreferences(String name) {
        return new AndroidPreferences(this.service.getSharedPreferences(name, 0));
    }

    public Clipboard getClipboard() {
        if (this.clipboard == null) {
            this.clipboard = new AndroidClipboard((Context)this.service);
        }
        return this.clipboard;
    }

    public void debug(String tag, String message) {
        if (this.logLevel >= 3) {
            Log.d((String)tag, (String)message);
        }
    }

    public void debug(String tag, String message, Throwable exception) {
        if (this.logLevel >= 3) {
            Log.d((String)tag, (String)message, (Throwable)exception);
        }
    }

    public void log(String tag, String message) {
        if (this.logLevel >= 2) {
            Log.i((String)tag, (String)message);
        }
    }

    public void log(String tag, String message, Throwable exception) {
        if (this.logLevel >= 2) {
            Log.i((String)tag, (String)message, (Throwable)exception);
        }
    }

    public void error(String tag, String message) {
        if (this.logLevel >= 1) {
            Log.e((String)tag, (String)message);
        }
    }

    public void error(String tag, String message, Throwable exception) {
        if (this.logLevel >= 1) {
            Log.e((String)tag, (String)message, (Throwable)exception);
        }
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void exit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.removeValue((Object)listener, true);
        }
    }

    public ApplicationListener getApplicationListener() {
        return this.listener;
    }

    static {
        GdxNativesLoader.load();
    }
}

