/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.opengl.GLU;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.SurfaceHolder;
import android.view.View;
import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.backends.android.AndroidApplicationConfiguration;
import com.badlogic.gdx.backends.android.AndroidGL10;
import com.badlogic.gdx.backends.android.AndroidGL11;
import com.badlogic.gdx.backends.android.AndroidGL20;
import com.badlogic.gdx.backends.android.AndroidLiveWallpaper;
import com.badlogic.gdx.backends.android.AndroidLiveWallpaperService;
import com.badlogic.gdx.backends.android.surfaceview.GLSurfaceView20;
import com.badlogic.gdx.backends.android.surfaceview.GLSurfaceViewAPI18;
import com.badlogic.gdx.backends.android.surfaceview.GLSurfaceViewCupcake;
import com.badlogic.gdx.backends.android.surfaceview.GdxEglConfigChooser;
import com.badlogic.gdx.backends.android.surfaceview.ResolutionStrategy;
import com.badlogic.gdx.graphics.GL10;
import com.badlogic.gdx.graphics.GL11;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.GLCommon;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.WindowedMean;
import com.badlogic.gdx.utils.Array;
import java.lang.reflect.Method;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;

public final class AndroidGraphicsLiveWallpaper
implements Graphics,
GLSurfaceView.Renderer {
    final View view;
    int width;
    int height;
    AndroidLiveWallpaper app;
    protected GLCommon gl;
    protected GL10 gl10;
    protected GL11 gl11;
    protected GL20 gl20;
    protected GLU glu;
    protected EGLContext eglContext;
    protected String extensions;
    protected long lastFrameTime = System.nanoTime();
    protected float deltaTime = 0.0f;
    protected long frameStart = System.nanoTime();
    protected int frames = 0;
    protected int fps;
    protected WindowedMean mean = new WindowedMean(5);
    volatile boolean created = false;
    volatile boolean running = false;
    volatile boolean pause = false;
    volatile boolean resume = false;
    volatile boolean destroy = false;
    protected float ppiX = 0.0f;
    protected float ppiY = 0.0f;
    protected float ppcX = 0.0f;
    protected float ppcY = 0.0f;
    protected float density = 1.0f;
    private final AndroidApplicationConfiguration config;
    private Graphics.BufferFormat bufferFormat = new Graphics.BufferFormat(5, 6, 5, 0, 16, 0, 0, false);
    protected boolean isContinuous = true;
    boolean configLogged = false;
    int[] value = new int[1];
    Object synch = new Object();

    public AndroidGraphicsLiveWallpaper(AndroidLiveWallpaper app, AndroidApplicationConfiguration config, ResolutionStrategy resolutionStrategy) {
        this.config = config;
        this.app = app;
        this.view = this.createGLSurfaceView((Context)app.service, config.useGL20, resolutionStrategy);
        this.setPreserveContext(this.view);
    }

    private void setPreserveContext(Object view) {
        int sdkVersion = Integer.parseInt(Build.VERSION.SDK);
        if (sdkVersion >= 11 && view instanceof GLSurfaceView) {
            try {
                Method method = null;
                for (Method m : view.getClass().getMethods()) {
                    if (!m.getName().equals("setPreserveEGLContextOnPause")) continue;
                    method = m;
                    break;
                }
                if (method != null) {
                    method.invoke((Object)((GLSurfaceView)view), true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SurfaceHolder getSurfaceHolder() {
        int[] nArray = this.app.service.sync;
        synchronized (this.app.service.sync) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.app.service.getSurfaceHolder();
        }
    }

    private View createGLSurfaceView(Context context, boolean useGL2, final ResolutionStrategy resolutionStrategy) {
        GLSurfaceView.EGLConfigChooser configChooser = this.getEglConfigChooser();
        if (useGL2 && this.checkGL20()) {
            GLSurfaceView20 view = new GLSurfaceView20(context, resolutionStrategy){

                public SurfaceHolder getHolder() {
                    return AndroidGraphicsLiveWallpaper.this.getSurfaceHolder();
                }

                public void onDestroy() {
                    this.onDetachedFromWindow();
                }
            };
            if (configChooser != null) {
                view.setEGLConfigChooser(configChooser);
            } else {
                view.setEGLConfigChooser(this.config.r, this.config.g, this.config.b, this.config.a, this.config.depth, this.config.stencil);
            }
            view.setRenderer(this);
            return view;
        }
        this.config.useGL20 = false;
        configChooser = this.getEglConfigChooser();
        int sdkVersion = Integer.parseInt(Build.VERSION.SDK);
        if (sdkVersion >= 11) {
            GLSurfaceView view = new GLSurfaceView(context){

                protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                    ResolutionStrategy.MeasuredDimension measures = resolutionStrategy.calcMeasures(widthMeasureSpec, heightMeasureSpec);
                    this.setMeasuredDimension(measures.width, measures.height);
                }

                public SurfaceHolder getHolder() {
                    return AndroidGraphicsLiveWallpaper.this.getSurfaceHolder();
                }

                public void onDestroy() {
                    this.onDetachedFromWindow();
                }
            };
            if (configChooser != null) {
                view.setEGLConfigChooser(configChooser);
            } else {
                view.setEGLConfigChooser(this.config.r, this.config.g, this.config.b, this.config.a, this.config.depth, this.config.stencil);
            }
            view.setRenderer((GLSurfaceView.Renderer)this);
            return view;
        }
        if (this.config.useGLSurfaceViewAPI18) {
            GLSurfaceViewAPI18 view = new GLSurfaceViewAPI18(context, resolutionStrategy){

                public SurfaceHolder getHolder() {
                    return AndroidGraphicsLiveWallpaper.this.getSurfaceHolder();
                }
            };
            if (configChooser != null) {
                view.setEGLConfigChooser(configChooser);
            } else {
                view.setEGLConfigChooser(this.config.r, this.config.g, this.config.b, this.config.a, this.config.depth, this.config.stencil);
            }
            view.setRenderer(this);
            return view;
        }
        GLSurfaceViewCupcake view = new GLSurfaceViewCupcake(context, resolutionStrategy){

            public SurfaceHolder getHolder() {
                return AndroidGraphicsLiveWallpaper.this.getSurfaceHolder();
            }
        };
        if (configChooser != null) {
            view.setEGLConfigChooser(configChooser);
        } else {
            view.setEGLConfigChooser(this.config.r, this.config.g, this.config.b, this.config.a, this.config.depth, this.config.stencil);
        }
        view.setRenderer(this);
        return view;
    }

    private GLSurfaceView.EGLConfigChooser getEglConfigChooser() {
        return new GdxEglConfigChooser(this.config.r, this.config.g, this.config.b, this.config.a, this.config.depth, this.config.stencil, this.config.numSamples, this.config.useGL20);
    }

    private void updatePpi() {
        DisplayMetrics metrics = new DisplayMetrics();
        this.app.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        this.ppiX = metrics.xdpi;
        this.ppiY = metrics.ydpi;
        this.ppcX = metrics.xdpi / 2.54f;
        this.ppcY = metrics.ydpi / 2.54f;
        this.density = metrics.density;
    }

    protected boolean checkGL20() {
        EGL10 egl = (EGL10)EGLContext.getEGL();
        EGLDisplay display = egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        int[] version = new int[2];
        egl.eglInitialize(display, version);
        int EGL_OPENGL_ES2_BIT = 4;
        int[] configAttribs = new int[]{12324, 4, 12323, 4, 12322, 4, 12352, EGL_OPENGL_ES2_BIT, 12344};
        EGLConfig[] configs = new EGLConfig[10];
        int[] num_config = new int[1];
        egl.eglChooseConfig(display, configAttribs, configs, 10, num_config);
        egl.eglTerminate(display);
        return num_config[0] > 0;
    }

    public GL10 getGL10() {
        return this.gl10;
    }

    public GL11 getGL11() {
        return this.gl11;
    }

    public GL20 getGL20() {
        return this.gl20;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isGL11Available() {
        return this.gl11 != null;
    }

    public boolean isGL20Available() {
        return this.gl20 != null;
    }

    private static boolean isPowerOfTwo(int value) {
        return value != 0 && (value & value - 1) == 0;
    }

    private void setupGL(javax.microedition.khronos.opengles.GL10 gl) {
        if (this.gl10 != null || this.gl20 != null) {
            return;
        }
        if (this.view instanceof GLSurfaceView20) {
            this.gl20 = new AndroidGL20();
            this.gl = this.gl20;
        } else {
            String renderer;
            this.gl10 = new AndroidGL10(gl);
            this.gl = this.gl10;
            if (!(!(gl instanceof javax.microedition.khronos.opengles.GL11) || (renderer = gl.glGetString(7937)) == null || renderer.toLowerCase().contains("pixelflinger") || Build.MODEL.equals("MB200") || Build.MODEL.equals("MB220") || Build.MODEL.contains("Behold"))) {
                this.gl11 = new AndroidGL11((javax.microedition.khronos.opengles.GL10)((javax.microedition.khronos.opengles.GL11)gl));
                this.gl10 = this.gl11;
            }
        }
        Gdx.gl = this.gl;
        Gdx.gl10 = this.gl10;
        Gdx.gl11 = this.gl11;
        Gdx.gl20 = this.gl20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceChanged(javax.microedition.khronos.opengles.GL10 gl, int width, int height) {
        this.width = width;
        this.height = height;
        this.updatePpi();
        gl.glViewport(0, 0, this.width, this.height);
        if (!this.created) {
            this.app.listener.create();
            this.created = true;
            AndroidGraphicsLiveWallpaper androidGraphicsLiveWallpaper = this;
            synchronized (androidGraphicsLiveWallpaper) {
                this.running = true;
            }
        }
        this.app.listener.resize(width, height);
    }

    public void onSurfaceCreated(javax.microedition.khronos.opengles.GL10 gl, EGLConfig config) {
        this.eglContext = ((EGL10)EGLContext.getEGL()).eglGetCurrentContext();
        this.setupGL(gl);
        this.logConfig(config);
        this.updatePpi();
        Mesh.invalidateAllMeshes((Application)this.app);
        Texture.invalidateAllTextures((Application)this.app);
        ShaderProgram.invalidateAllShaderPrograms((Application)this.app);
        FrameBuffer.invalidateAllFrameBuffers((Application)this.app);
        if (AndroidLiveWallpaperService.DEBUG) {
            Gdx.app.debug("AndroidGraphics", Mesh.getManagedStatus());
            Gdx.app.debug("AndroidGraphics", Texture.getManagedStatus());
            Gdx.app.debug("AndroidGraphics", ShaderProgram.getManagedStatus());
            Gdx.app.debug("AndroidGraphics", FrameBuffer.getManagedStatus());
        }
        Display display = this.app.getWindowManager().getDefaultDisplay();
        this.width = display.getWidth();
        this.height = display.getHeight();
        this.mean = new WindowedMean(5);
        this.lastFrameTime = System.nanoTime();
        gl.glViewport(0, 0, this.width, this.height);
    }

    private void logConfig(EGLConfig config) {
        boolean coverageSample;
        EGL10 egl = (EGL10)EGLContext.getEGL();
        EGLDisplay display = egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        int r = this.getAttrib(egl, display, config, 12324, 0);
        int g = this.getAttrib(egl, display, config, 12323, 0);
        int b = this.getAttrib(egl, display, config, 12322, 0);
        int a = this.getAttrib(egl, display, config, 12321, 0);
        int d = this.getAttrib(egl, display, config, 12325, 0);
        int s = this.getAttrib(egl, display, config, 12326, 0);
        int samples = Math.max(this.getAttrib(egl, display, config, 12337, 0), this.getAttrib(egl, display, config, 12513, 0));
        boolean bl = coverageSample = this.getAttrib(egl, display, config, 12513, 0) != 0;
        if (!this.configLogged) {
            if (this.gl != null) {
                Gdx.app.log("AndroidGraphics", "OGL renderer: " + this.gl.glGetString(7937));
                Gdx.app.log("AndroidGraphics", "OGL vendor: " + this.gl.glGetString(7936));
                Gdx.app.log("AndroidGraphics", "OGL version: " + this.gl.glGetString(7938));
                Gdx.app.log("AndroidGraphics", "OGL extensions: " + this.gl.glGetString(7939));
                this.configLogged = true;
            }
            Gdx.app.log("AndroidGraphics", "framebuffer: (" + r + ", " + g + ", " + b + ", " + a + ")");
            Gdx.app.log("AndroidGraphics", "depthbuffer: (" + d + ")");
            Gdx.app.log("AndroidGraphics", "stencilbuffer: (" + s + ")");
            Gdx.app.log("AndroidGraphics", "samples: (" + samples + ")");
            Gdx.app.log("AndroidGraphics", "coverage sampling: (" + coverageSample + ")");
        }
        this.bufferFormat = new Graphics.BufferFormat(r, g, b, a, d, s, samples, coverageSample);
    }

    private int getAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attrib, int defValue) {
        if (egl.eglGetConfigAttrib(display, config, attrib, this.value)) {
            return this.value[0];
        }
        return defValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resume() {
        Object object = this.synch;
        synchronized (object) {
            this.running = true;
            this.resume = true;
            while (this.resume) {
                try {
                    this.synch.wait();
                }
                catch (InterruptedException ignored) {
                    Gdx.app.log("AndroidGraphics", "waiting for resume synchronization failed!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pause() {
        Object object = this.synch;
        synchronized (object) {
            if (!this.running) {
                return;
            }
            this.running = false;
            this.pause = true;
            while (this.pause) {
                try {
                    this.synch.wait();
                }
                catch (InterruptedException ignored) {
                    Gdx.app.log("AndroidGraphics", "waiting for pause synchronization failed!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        Object object = this.synch;
        synchronized (object) {
            this.running = false;
            this.destroy = true;
            while (this.destroy) {
                try {
                    this.synch.wait();
                }
                catch (InterruptedException ex) {
                    Gdx.app.log("AndroidGraphics", "waiting for destroy synchronization failed!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDrawFrame(javax.microedition.khronos.opengles.GL10 gl) {
        long time = System.nanoTime();
        this.deltaTime = (float)(time - this.lastFrameTime) / 1.0E9f;
        this.lastFrameTime = time;
        this.mean.addValue(this.resume ? 0.0f : this.deltaTime);
        boolean lrunning = false;
        boolean lpause = false;
        boolean ldestroy = false;
        boolean lresume = false;
        Array<Runnable> array = this.synch;
        synchronized (array) {
            lrunning = this.running;
            lpause = this.pause;
            ldestroy = this.destroy;
            lresume = this.resume;
            if (this.resume) {
                this.resume = false;
                this.synch.notifyAll();
            }
            if (this.pause) {
                this.pause = false;
                this.synch.notifyAll();
            }
            if (this.destroy) {
                this.destroy = false;
                this.synch.notifyAll();
            }
        }
        if (lresume) {
            this.app.listener.resume();
            Gdx.app.log("AndroidGraphics", "resumed");
        }
        if (lrunning && (Gdx.graphics.getGL10() != null || Gdx.graphics.getGL11() != null || Gdx.graphics.getGL20() != null)) {
            array = this.app.runnables;
            synchronized (array) {
                this.app.executedRunnables.clear();
                this.app.executedRunnables.addAll(this.app.runnables);
                this.app.runnables.clear();
                for (int i = 0; i < this.app.executedRunnables.size; ++i) {
                    try {
                        ((Runnable)this.app.executedRunnables.get(i)).run();
                        continue;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
            this.app.input.processEvents();
            this.app.listener.render();
        }
        if (lpause) {
            this.app.listener.pause();
            Gdx.app.log("AndroidGraphics", "paused");
        }
        if (ldestroy) {
            this.app.listener.dispose();
            Gdx.app.log("AndroidGraphics", "destroyed");
        }
        if (time - this.frameStart > 1000000000L) {
            this.fps = this.frames;
            this.frames = 0;
            this.frameStart = time;
        }
        ++this.frames;
    }

    public float getDeltaTime() {
        return this.mean.getMean() == 0.0f ? this.deltaTime : this.mean.getMean();
    }

    public float getRawDeltaTime() {
        return this.deltaTime;
    }

    public Graphics.GraphicsType getType() {
        return Graphics.GraphicsType.AndroidGL;
    }

    public int getFramesPerSecond() {
        return this.fps;
    }

    public void clearManagedCaches() {
        Mesh.clearAllMeshes((Application)this.app);
        Texture.clearAllTextures((Application)this.app);
        ShaderProgram.clearAllShaderPrograms((Application)this.app);
        FrameBuffer.clearAllFrameBuffers((Application)this.app);
        if (AndroidLiveWallpaperService.DEBUG) {
            Gdx.app.debug("AndroidGraphics", Mesh.getManagedStatus());
            Gdx.app.debug("AndroidGraphics", Texture.getManagedStatus());
            Gdx.app.debug("AndroidGraphics", ShaderProgram.getManagedStatus());
            Gdx.app.debug("AndroidGraphics", FrameBuffer.getManagedStatus());
        }
    }

    public View getView() {
        return this.view;
    }

    public GLCommon getGLCommon() {
        return this.gl;
    }

    public float getPpiX() {
        return this.ppiX;
    }

    public float getPpiY() {
        return this.ppiY;
    }

    public float getPpcX() {
        return this.ppcX;
    }

    public float getPpcY() {
        return this.ppcY;
    }

    public float getDensity() {
        return this.density;
    }

    public boolean supportsDisplayModeChange() {
        return false;
    }

    public boolean setDisplayMode(Graphics.DisplayMode displayMode) {
        return false;
    }

    public Graphics.DisplayMode[] getDisplayModes() {
        return new Graphics.DisplayMode[]{this.getDesktopDisplayMode()};
    }

    public boolean setDisplayMode(int width, int height, boolean fullscreen) {
        return false;
    }

    public void setTitle(String title) {
    }

    public Graphics.DisplayMode getDesktopDisplayMode() {
        DisplayMetrics metrics = new DisplayMetrics();
        this.app.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        return new AndroidDisplayMode(metrics.widthPixels, metrics.heightPixels, 0, 0);
    }

    public Graphics.BufferFormat getBufferFormat() {
        return this.bufferFormat;
    }

    public void setVSync(boolean vsync) {
    }

    public boolean supportsExtension(String extension) {
        if (this.extensions == null) {
            this.extensions = Gdx.gl.glGetString(7939);
        }
        return this.extensions.contains(extension);
    }

    public void setContinuousRendering(boolean isContinuous) {
        if (this.view != null) {
            int renderMode;
            this.isContinuous = isContinuous;
            int n = renderMode = isContinuous ? 1 : 0;
            if (this.view instanceof GLSurfaceViewCupcake) {
                ((GLSurfaceViewCupcake)this.view).setRenderMode(renderMode);
            } else if (this.view instanceof GLSurfaceViewAPI18) {
                ((GLSurfaceViewAPI18)this.view).setRenderMode(renderMode);
            } else if (this.view instanceof GLSurfaceView) {
                ((GLSurfaceView)this.view).setRenderMode(renderMode);
            } else {
                throw new RuntimeException("unimplemented");
            }
            this.mean.clear();
        }
    }

    public boolean isContinuousRendering() {
        return this.isContinuous;
    }

    public void requestRendering() {
        if (this.view != null) {
            if (this.view instanceof GLSurfaceViewCupcake) {
                ((GLSurfaceViewCupcake)this.view).requestRender();
            } else if (this.view instanceof GLSurfaceViewAPI18) {
                ((GLSurfaceViewAPI18)this.view).requestRender();
            } else if (this.view instanceof GLSurfaceView) {
                ((GLSurfaceView)this.view).requestRender();
            } else {
                throw new RuntimeException("unimplemented");
            }
        }
    }

    public boolean isFullscreen() {
        return true;
    }

    private class AndroidDisplayMode
    extends Graphics.DisplayMode {
        protected AndroidDisplayMode(int width, int height, int refreshRate, int bitsPerPixel) {
            super(width, height, refreshRate, bitsPerPixel);
        }
    }
}

