/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class AndroidFileHandle
extends FileHandle {
    final AssetManager assets;

    AndroidFileHandle(AssetManager assets, String fileName, Files.FileType type) {
        super(fileName.replace('\\', '/'), type);
        this.assets = assets;
    }

    AndroidFileHandle(AssetManager assets, File file, Files.FileType type) {
        super(file, type);
        this.assets = assets;
    }

    public FileHandle child(String name) {
        name = name.replace('\\', '/');
        if (this.file.getPath().length() == 0) {
            return new AndroidFileHandle(this.assets, new File(name), this.type);
        }
        return new AndroidFileHandle(this.assets, new File(this.file, name), this.type);
    }

    public FileHandle sibling(String name) {
        name = name.replace('\\', '/');
        if (this.file.getPath().length() == 0) {
            throw new GdxRuntimeException("Cannot get the sibling of the root.");
        }
        return new AndroidFileHandle(this.assets, new File(this.file.getParent(), name), this.type);
    }

    public FileHandle parent() {
        File parent = this.file.getParentFile();
        if (parent == null) {
            parent = this.type == Files.FileType.Absolute ? new File("/") : new File("");
        }
        return new AndroidFileHandle(this.assets, parent, this.type);
    }

    public InputStream read() {
        if (this.type == Files.FileType.Internal) {
            try {
                return this.assets.open(this.file.getPath());
            }
            catch (IOException ex) {
                throw new GdxRuntimeException("Error reading file: " + this.file + " (" + this.type + ")", (Throwable)ex);
            }
        }
        return super.read();
    }

    public FileHandle[] list() {
        if (this.type == Files.FileType.Internal) {
            try {
                String[] relativePaths = this.assets.list(this.file.getPath());
                FileHandle[] handles = new FileHandle[relativePaths.length];
                int n = handles.length;
                for (int i = 0; i < n; ++i) {
                    handles[i] = new AndroidFileHandle(this.assets, new File(this.file, relativePaths[i]), this.type);
                }
                return handles;
            }
            catch (Exception ex) {
                throw new GdxRuntimeException("Error listing children: " + this.file + " (" + this.type + ")", (Throwable)ex);
            }
        }
        return super.list();
    }

    public FileHandle[] list(String suffix) {
        if (this.type == Files.FileType.Internal) {
            try {
                String[] relativePaths = this.assets.list(this.file.getPath());
                FileHandle[] handles = new FileHandle[relativePaths.length];
                int count = 0;
                int n = handles.length;
                for (int i = 0; i < n; ++i) {
                    String path = relativePaths[i];
                    if (!path.endsWith(suffix)) continue;
                    handles[count] = new AndroidFileHandle(this.assets, new File(this.file, path), this.type);
                    ++count;
                }
                if (count < relativePaths.length) {
                    FileHandle[] newHandles = new FileHandle[count];
                    System.arraycopy(handles, 0, newHandles, 0, count);
                    handles = newHandles;
                }
                return handles;
            }
            catch (Exception ex) {
                throw new GdxRuntimeException("Error listing children: " + this.file + " (" + this.type + ")", (Throwable)ex);
            }
        }
        return super.list(suffix);
    }

    public boolean isDirectory() {
        if (this.type == Files.FileType.Internal) {
            try {
                return this.assets.list(this.file.getPath()).length > 0;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return super.isDirectory();
    }

    public boolean exists() {
        if (this.type == Files.FileType.Internal) {
            String fileName = this.file.getPath();
            try {
                this.assets.open(fileName).close();
                return true;
            }
            catch (Exception ex) {
                try {
                    return this.assets.list(fileName).length > 0;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }
        return super.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() {
        if (this.type == Files.FileType.Internal) {
            AssetFileDescriptor fileDescriptor = null;
            try {
                fileDescriptor = this.assets.openFd(this.file.getPath());
                long l = fileDescriptor.getLength();
                return l;
            }
            catch (IOException ignored) {
            }
            finally {
                if (fileDescriptor != null) {
                    try {
                        fileDescriptor.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return super.length();
    }

    public long lastModified() {
        return super.lastModified();
    }
}

