/*******************************************************************************
 * Copyright 2011 See AUTHORS file.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/

package com.badlogic.gdx.backends.android;

import android.media.SoundPool;
import android.os.PowerManager.WakeLock;

import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.backends.android.surfaceview.FillResolutionStrategy;
import com.badlogic.gdx.backends.android.surfaceview.ResolutionStrategy;

/** Class defining the configuration of an {@link AndroidApplication}. Allows you to disable the use of the accelerometer to save
 * battery among other things.
 * @author mzechner */
public class AndroidApplicationConfiguration {
	/** whether to use OpenGL ES 2.0 or not. default: false **/
	public boolean useGL20 = false;

	/** number of bits per color channel **/
	public int r = 5, g = 6, b = 5, a = 0;

	/** number of bits for depth and stencil buffer **/
	public int depth = 16, stencil = 0;

	/** number of samples for CSAA/MSAA, 2 is a good value **/
	public int numSamples = 0;

	/** whether to use the accelerometer. default: true **/
	public boolean useAccelerometer = true;

	/** whether to use the compass. default: true **/
	public boolean useCompass = true;

	/** the time in milliseconds to sleep after each event in the touch handler, set this to 16ms to get rid of touch flooding on
	 * pre Android 2.0 devices. default: 0 **/
	public int touchSleepTime = 0;

	/** whether to use a {@link WakeLock} or not. In case this is true you have to add the permission "android.permission.WAKE_LOCK"
	 * to your manifest file. default: false */
	public boolean useWakelock = false;

	/** hide status bar buttons on Android 4.x and higher (API 14+). Doesn't work if "android:targetSdkVersion" less 11 or if API
	 * less 14. default: false **/
	public boolean hideStatusBar = false;

	/** the maximum number of {@link Sound} instances that can be played simultaneously, sets the corresponding {@link SoundPool}
	 * constructor argument. */
	public int maxSimultaneousSounds = 16;

	/** the {@link ResolutionStrategy}. default: {@link FillResolutionStrategy} **/
	public ResolutionStrategy resolutionStrategy = new FillResolutionStrategy();
	
	/** if the app is a livewallpaper, whether it should get full touch events **/
	public boolean getTouchEventsForLiveWallpaper = false; 

	/** whether to use {@link GLSurfaceViewAPI18} in place of the classic {@link GLSurfaceViewCupcake} on Android API 10 and lower.
	 * In case this is true {@link GLSurfaceViewAPI18} will be used. This implementation properly supports attach to and detach
	 * from window. default: false */
	public boolean useGLSurfaceViewAPI18 = false;
}
