/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.storage.queue.implementation.factory;

import com.azure.spring.cloud.core.implementation.util.AzureSpringIdentifier;
import com.azure.spring.cloud.service.implementation.storage.queue.QueueServiceClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.storage.queue.QueueServiceClientProperties;
import com.azure.spring.messaging.storage.queue.core.factory.StorageQueueClientFactory;
import com.azure.spring.messaging.storage.queue.core.properties.StorageQueueProperties;
import com.azure.storage.queue.QueueAsyncClient;
import com.azure.storage.queue.QueueServiceAsyncClient;
import com.azure.storage.queue.QueueServiceClientBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.lang.NonNull;

public final class DefaultStorageQueueClientFactory
implements StorageQueueClientFactory,
DisposableBean {
    private final List<StorageQueueClientFactory.Listener> listeners = new ArrayList<StorageQueueClientFactory.Listener>();
    private final Map<String, QueueAsyncClient> clients = new ConcurrentHashMap<String, QueueAsyncClient>();
    private final QueueServiceAsyncClient queueServiceAsyncClient;

    public DefaultStorageQueueClientFactory(@NonNull StorageQueueProperties storageQueueProperties) {
        QueueServiceClientBuilderFactory queueServiceClientBuilderFactory = new QueueServiceClientBuilderFactory((QueueServiceClientProperties)storageQueueProperties);
        queueServiceClientBuilderFactory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_INTEGRATION_STORAGE_QUEUE);
        this.queueServiceAsyncClient = ((QueueServiceClientBuilder)queueServiceClientBuilderFactory.build()).buildAsyncClient();
    }

    @Override
    public QueueAsyncClient createQueueClient(String queueName) {
        return this.clients.computeIfAbsent(queueName, q -> {
            QueueAsyncClient queueClient = this.queueServiceAsyncClient.getQueueAsyncClient(queueName);
            this.listeners.forEach(l -> l.queueClientAdded(queueName, queueClient));
            return queueClient;
        });
    }

    @Override
    public void addListener(StorageQueueClientFactory.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(StorageQueueClientFactory.Listener listener) {
        return this.listeners.remove(listener);
    }

    public void destroy() {
        this.clients.forEach((name, client) -> this.listeners.forEach(l -> l.queueClientRemoved((String)name, (QueueAsyncClient)client)));
        this.clients.clear();
        this.listeners.clear();
    }
}

