/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.integration.core.implementation.instrumentation;

import com.azure.spring.integration.core.instrumentation.Instrumentation;
import java.time.Duration;

public abstract class AbstractProcessorInstrumentation<T>
implements Instrumentation {
    private final String name;
    private final Instrumentation.Type type;
    private final Duration noneErrorWindow;
    private volatile long lastErrorTimestamp = Long.MIN_VALUE;
    private T errorContext;

    public AbstractProcessorInstrumentation(String name, Instrumentation.Type type, Duration noneErrorWindow) {
        this.name = name;
        this.type = type;
        this.noneErrorWindow = noneErrorWindow;
    }

    @Override
    public Instrumentation.Type getType() {
        return this.type;
    }

    @Override
    public void setStatus(Instrumentation.Status status) {
    }

    @Override
    public void setStatus(Instrumentation.Status status, Throwable exception) {
    }

    @Override
    public Instrumentation.Status getStatus() {
        if (System.currentTimeMillis() > this.lastErrorTimestamp + this.noneErrorWindow.toMillis()) {
            this.errorContext = null;
            return Instrumentation.Status.UP;
        }
        return Instrumentation.Status.DOWN;
    }

    public void markError(T errorContext) {
        this.errorContext = errorContext;
        this.lastErrorTimestamp = System.currentTimeMillis();
    }

    public T getErrorContext() {
        return this.errorContext;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

