/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.testcontainers.implementation.service.connection.cosmos;

import com.azure.cosmos.ConnectionMode;
import com.azure.spring.cloud.autoconfigure.implementation.cosmos.properties.AzureCosmosConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.CosmosDBEmulatorContainer;

class CosmosContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<CosmosDBEmulatorContainer, AzureCosmosConnectionDetails> {
    CosmosContainerConnectionDetailsFactory() {
    }

    protected AzureCosmosConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<CosmosDBEmulatorContainer> source) {
        return new CosmosContainerConnectionDetails(source);
    }

    private static class CosmosContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<CosmosDBEmulatorContainer>
    implements AzureCosmosConnectionDetails {
        CosmosContainerConnectionDetails(ContainerConnectionSource<CosmosDBEmulatorContainer> source) {
            super(source);
        }

        public String getEndpoint() {
            return ((CosmosDBEmulatorContainer)this.getContainer()).getEmulatorEndpoint();
        }

        public String getKey() {
            return ((CosmosDBEmulatorContainer)this.getContainer()).getEmulatorKey();
        }

        public String getDatabase() {
            return "test-emulator";
        }

        public Boolean getEndpointDiscoveryEnabled() {
            return false;
        }

        public ConnectionMode getConnectionMode() {
            return ConnectionMode.GATEWAY;
        }
    }
}

