/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.stream.binder.servicebus.core.properties;

import com.azure.spring.cloud.service.implementation.core.PropertiesValidator;
import com.azure.spring.cloud.stream.binder.servicebus.core.properties.ServiceBusBindingProperties;
import com.azure.spring.cloud.stream.binder.servicebus.core.properties.ServiceBusConsumerProperties;
import com.azure.spring.cloud.stream.binder.servicebus.core.properties.ServiceBusProducerProperties;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.stream.binder.AbstractExtendedBindingProperties;
import org.springframework.cloud.stream.binder.BinderSpecificPropertiesProvider;

@ConfigurationProperties(value="spring.cloud.stream.servicebus")
public class ServiceBusExtendedBindingProperties
extends AbstractExtendedBindingProperties<ServiceBusConsumerProperties, ServiceBusProducerProperties, ServiceBusBindingProperties>
implements InitializingBean {
    private static final String DEFAULTS_PREFIX = "spring.cloud.stream.servicebus.default";
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceBusExtendedBindingProperties.class);

    public String getDefaultsPrefix() {
        return DEFAULTS_PREFIX;
    }

    public Class<? extends BinderSpecificPropertiesProvider> getExtendedPropertiesEntryClass() {
        return ServiceBusBindingProperties.class;
    }

    public Map<String, ServiceBusBindingProperties> getBindings() {
        return this.doGetBindings();
    }

    public void afterPropertiesSet() throws Exception {
        try {
            this.validateNamespaceProperties();
        }
        catch (IllegalArgumentException exception) {
            LOGGER.warn(exception.getMessage());
        }
    }

    private void validateNamespaceProperties() {
        this.getBindings().values().stream().map(bindings -> bindings.getConsumer().getNamespace()).filter(Objects::nonNull).forEach(PropertiesValidator::validateNamespace);
        this.getBindings().values().stream().map(bindings -> bindings.getProducer().getNamespace()).filter(Objects::nonNull).forEach(PropertiesValidator::validateNamespace);
    }
}

