/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.stream.binder.eventhubs.implementation.config;

import com.azure.core.credential.TokenCredential;
import com.azure.messaging.eventhubs.CheckpointStore;
import com.azure.messaging.eventhubs.EventHubClientBuilder;
import com.azure.messaging.eventhubs.EventProcessorClientBuilder;
import com.azure.spring.cloud.autoconfigure.implementation.context.AzureGlobalPropertiesAutoConfiguration;
import com.azure.spring.cloud.autoconfigure.implementation.context.AzureTokenCredentialAutoConfiguration;
import com.azure.spring.cloud.autoconfigure.implementation.eventhubs.AzureEventHubsAutoConfiguration;
import com.azure.spring.cloud.autoconfigure.implementation.eventhubs.AzureEventHubsMessagingAutoConfiguration;
import com.azure.spring.cloud.autoconfigure.implementation.eventhubs.properties.AzureEventHubsProperties;
import com.azure.spring.cloud.autoconfigure.implementation.resourcemanager.AzureEventHubsResourceManagerAutoConfiguration;
import com.azure.spring.cloud.autoconfigure.implementation.resourcemanager.AzureResourceManagerAutoConfiguration;
import com.azure.spring.cloud.core.credential.AzureCredentialResolver;
import com.azure.spring.cloud.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.cloud.core.implementation.credential.resolver.AzureTokenCredentialResolver;
import com.azure.spring.cloud.resourcemanager.implementation.provisioning.EventHubsProvisioner;
import com.azure.spring.cloud.stream.binder.eventhubs.config.EventHubsProcessorFactoryCustomizer;
import com.azure.spring.cloud.stream.binder.eventhubs.config.EventHubsProducerFactoryCustomizer;
import com.azure.spring.cloud.stream.binder.eventhubs.core.implementation.provisioning.EventHubsChannelProvisioner;
import com.azure.spring.cloud.stream.binder.eventhubs.core.properties.EventHubsExtendedBindingProperties;
import com.azure.spring.cloud.stream.binder.eventhubs.implementation.EventHubsMessageChannelBinder;
import com.azure.spring.cloud.stream.binder.eventhubs.implementation.config.EventHubsBinderHealthIndicatorConfiguration;
import com.azure.spring.cloud.stream.binder.eventhubs.implementation.provisioning.EventHubsChannelResourceManagerProvisioner;
import com.azure.spring.messaging.eventhubs.core.DefaultEventHubsNamespaceProcessorFactory;
import com.azure.spring.messaging.eventhubs.core.DefaultEventHubsNamespaceProducerFactory;
import com.azure.spring.messaging.eventhubs.core.EventHubsProcessorFactory;
import com.azure.spring.messaging.eventhubs.core.EventHubsProducerFactory;
import com.azure.spring.messaging.eventhubs.core.properties.NamespaceProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(value={Binder.class})
@Import(value={AzureGlobalPropertiesAutoConfiguration.class, AzureTokenCredentialAutoConfiguration.class, AzureResourceManagerAutoConfiguration.class, AzureEventHubsResourceManagerAutoConfiguration.class, AzureEventHubsAutoConfiguration.class, AzureEventHubsMessagingAutoConfiguration.class, EventHubsBinderHealthIndicatorConfiguration.class})
@EnableConfigurationProperties(value={EventHubsExtendedBindingProperties.class})
public class EventHubsBinderConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={EventHubsProvisioner.class, AzureEventHubsProperties.class})
    EventHubsChannelProvisioner eventHubChannelArmProvisioner(AzureEventHubsProperties eventHubsProperties, EventHubsProvisioner eventHubsProvisioner) {
        return new EventHubsChannelResourceManagerProvisioner(eventHubsProperties.getNamespace(), eventHubsProvisioner);
    }

    @Bean
    @ConditionalOnMissingBean(value={EventHubsProvisioner.class, EventHubsChannelProvisioner.class})
    EventHubsChannelProvisioner eventHubChannelProvisioner() {
        return new EventHubsChannelProvisioner();
    }

    @Bean
    @ConditionalOnMissingBean
    EventHubsMessageChannelBinder eventHubBinder(EventHubsChannelProvisioner channelProvisioner, EventHubsExtendedBindingProperties bindingProperties, ObjectProvider<NamespaceProperties> namespaceProperties, ObjectProvider<CheckpointStore> checkpointStores, ObjectProvider<EventHubsProducerFactoryCustomizer> producerFactoryCustomizers, ObjectProvider<EventHubsProcessorFactoryCustomizer> processorFactoryCustomizers) {
        EventHubsMessageChannelBinder binder = new EventHubsMessageChannelBinder(null, channelProvisioner);
        binder.setBindingProperties(bindingProperties);
        binder.setNamespaceProperties((NamespaceProperties)namespaceProperties.getIfAvailable());
        checkpointStores.ifAvailable(binder::setCheckpointStore);
        producerFactoryCustomizers.orderedStream().forEach(binder::addProducerFactoryCustomizer);
        processorFactoryCustomizers.orderedStream().forEach(binder::addProcessorFactoryCustomizer);
        return binder;
    }

    @Bean
    @ConditionalOnMissingBean
    EventHubsProducerFactoryCustomizer defaultEventHubsProducerFactoryCustomizer(ApplicationContext applicationContext, AzureTokenCredentialResolver azureTokenCredentialResolver, @Qualifier(value="springCloudAzureDefaultCredential") TokenCredential defaultAzureCredential, ObjectProvider<AzureServiceClientBuilderCustomizer<EventHubClientBuilder>> clientBuilderCustomizers) {
        return new DefaultProducerFactoryCustomizer(applicationContext, defaultAzureCredential, azureTokenCredentialResolver, clientBuilderCustomizers);
    }

    @Bean
    @ConditionalOnMissingBean
    EventHubsProcessorFactoryCustomizer defaultEventHubsProcessorFactoryCustomizer(ApplicationContext applicationContext, AzureTokenCredentialResolver azureTokenCredentialResolver, @Qualifier(value="springCloudAzureDefaultCredential") TokenCredential defaultCredential, ObjectProvider<AzureServiceClientBuilderCustomizer<EventProcessorClientBuilder>> processorClientBuilderCustomizers) {
        return new DefaultProcessorFactoryCustomizer(applicationContext, defaultCredential, azureTokenCredentialResolver, processorClientBuilderCustomizers);
    }

    static class DefaultProducerFactoryCustomizer
    implements EventHubsProducerFactoryCustomizer {
        private final ApplicationContext applicationContext;
        private final TokenCredential defaultCredential;
        private final AzureTokenCredentialResolver tokenCredentialResolver;
        private final ObjectProvider<AzureServiceClientBuilderCustomizer<EventHubClientBuilder>> clientBuilderCustomizers;

        DefaultProducerFactoryCustomizer(ApplicationContext applicationContext, TokenCredential defaultCredential, AzureTokenCredentialResolver azureTokenCredentialResolver, ObjectProvider<AzureServiceClientBuilderCustomizer<EventHubClientBuilder>> clientBuilderCustomizers) {
            this.applicationContext = applicationContext;
            this.defaultCredential = defaultCredential;
            this.tokenCredentialResolver = azureTokenCredentialResolver;
            this.clientBuilderCustomizers = clientBuilderCustomizers;
        }

        @Override
        public void customize(EventHubsProducerFactory factory) {
            if (factory instanceof DefaultEventHubsNamespaceProducerFactory) {
                DefaultEventHubsNamespaceProducerFactory defaultFactory = (DefaultEventHubsNamespaceProducerFactory)factory;
                defaultFactory.setApplicationContext(this.applicationContext);
                defaultFactory.setDefaultCredential(this.defaultCredential);
                defaultFactory.setTokenCredentialResolver((AzureCredentialResolver)this.tokenCredentialResolver);
                this.clientBuilderCustomizers.orderedStream().forEach(arg_0 -> ((DefaultEventHubsNamespaceProducerFactory)defaultFactory).addBuilderCustomizer(arg_0));
            }
        }

        ObjectProvider<AzureServiceClientBuilderCustomizer<EventHubClientBuilder>> getClientBuilderCustomizers() {
            return this.clientBuilderCustomizers;
        }
    }

    static class DefaultProcessorFactoryCustomizer
    implements EventHubsProcessorFactoryCustomizer {
        private final ApplicationContext applicationContext;
        private final TokenCredential defaultCredential;
        private final AzureTokenCredentialResolver tokenCredentialResolver;
        private final ObjectProvider<AzureServiceClientBuilderCustomizer<EventProcessorClientBuilder>> processorClientBuilderCustomizers;

        DefaultProcessorFactoryCustomizer(ApplicationContext applicationContext, TokenCredential defaultCredential, AzureTokenCredentialResolver azureTokenCredentialResolver, ObjectProvider<AzureServiceClientBuilderCustomizer<EventProcessorClientBuilder>> processorClientBuilderCustomizers) {
            this.applicationContext = applicationContext;
            this.defaultCredential = defaultCredential;
            this.tokenCredentialResolver = azureTokenCredentialResolver;
            this.processorClientBuilderCustomizers = processorClientBuilderCustomizers;
        }

        @Override
        public void customize(EventHubsProcessorFactory factory) {
            if (factory instanceof DefaultEventHubsNamespaceProcessorFactory) {
                DefaultEventHubsNamespaceProcessorFactory defaultFactory = (DefaultEventHubsNamespaceProcessorFactory)factory;
                defaultFactory.setApplicationContext(this.applicationContext);
                defaultFactory.setDefaultCredential(this.defaultCredential);
                defaultFactory.setTokenCredentialResolver((AzureCredentialResolver)this.tokenCredentialResolver);
                this.processorClientBuilderCustomizers.orderedStream().forEach(arg_0 -> ((DefaultEventHubsNamespaceProcessorFactory)defaultFactory).addBuilderCustomizer(arg_0));
            }
        }

        ObjectProvider<AzureServiceClientBuilderCustomizer<EventProcessorClientBuilder>> getProcessorClientBuilderCustomizers() {
            return this.processorClientBuilderCustomizers;
        }
    }
}

