/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.stream.binder.eventhubs.implementation;

import com.azure.spring.cloud.stream.binder.eventhubs.implementation.EventHubsMessageChannelBinder;
import com.azure.spring.integration.core.instrumentation.Instrumentation;
import com.azure.spring.integration.core.instrumentation.InstrumentationManager;
import org.springframework.boot.health.contributor.AbstractHealthIndicator;
import org.springframework.boot.health.contributor.Health;

public class EventHubsHealthIndicator
extends AbstractHealthIndicator {
    private final InstrumentationManager instrumentationManager;

    public EventHubsHealthIndicator(EventHubsMessageChannelBinder binder) {
        super("Event hubs health check failed");
        this.instrumentationManager = binder.getInstrumentationManager();
    }

    protected void doHealthCheck(Health.Builder builder) {
        if (this.instrumentationManager == null || this.instrumentationManager.getAllHealthInstrumentation().isEmpty()) {
            builder.unknown();
            return;
        }
        if (this.instrumentationManager.getAllHealthInstrumentation().stream().allMatch(instr -> Instrumentation.Status.UP.equals((Object)instr.getStatus()))) {
            builder.up();
            return;
        }
        builder.down();
        this.instrumentationManager.getAllHealthInstrumentation().stream().filter(instr -> Instrumentation.Status.DOWN.equals((Object)instr.getStatus())).forEach(instr -> builder.withDetail(instr.getId(), (Object)instr.getException()));
    }
}

