/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.storage.credential;

import com.azure.spring.cloud.core.credential.AzureCredentialResolver;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.service.implementation.storage.common.StorageProperties;
import com.azure.storage.common.StorageSharedKeyCredential;
import org.springframework.util.StringUtils;

public final class StorageSharedKeyCredentialResolver
implements AzureCredentialResolver<StorageSharedKeyCredential> {
    public StorageSharedKeyCredential resolve(AzureProperties azureProperties) {
        if (!this.isResolvable(azureProperties)) {
            return null;
        }
        StorageProperties properties = (StorageProperties)azureProperties;
        if (!StringUtils.hasText((String)properties.getAccountName()) || !StringUtils.hasText((String)properties.getAccountKey())) {
            return null;
        }
        return new StorageSharedKeyCredential(properties.getAccountName(), properties.getAccountKey());
    }

    public boolean isResolvable(AzureProperties azureProperties) {
        return azureProperties instanceof StorageProperties;
    }
}

