/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.appconfiguration;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.data.appconfiguration.ConfigurationClientBuilder;
import com.azure.spring.cloud.core.implementation.credential.descriptor.AuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.TokenAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.factory.AbstractAzureHttpClientBuilderFactory;
import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.service.implementation.appconfiguration.ConfigurationClientProperties;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;

public class ConfigurationClientBuilderFactory
extends AbstractAzureHttpClientBuilderFactory<ConfigurationClientBuilder> {
    private final ConfigurationClientProperties configurationClientProperties;

    public ConfigurationClientBuilderFactory(ConfigurationClientProperties configurationClientProperties) {
        this.configurationClientProperties = configurationClientProperties;
    }

    protected BiConsumer<ConfigurationClientBuilder, ClientOptions> consumeClientOptions() {
        return ConfigurationClientBuilder::clientOptions;
    }

    protected BiConsumer<ConfigurationClientBuilder, HttpClient> consumeHttpClient() {
        return ConfigurationClientBuilder::httpClient;
    }

    protected BiConsumer<ConfigurationClientBuilder, HttpPipelinePolicy> consumeHttpPipelinePolicy() {
        return ConfigurationClientBuilder::addPolicy;
    }

    protected BiConsumer<ConfigurationClientBuilder, HttpPipeline> consumeHttpPipeline() {
        return ConfigurationClientBuilder::pipeline;
    }

    protected BiConsumer<ConfigurationClientBuilder, HttpLogOptions> consumeHttpLogOptions() {
        return ConfigurationClientBuilder::httpLogOptions;
    }

    protected ConfigurationClientBuilder createBuilderInstance() {
        return new ConfigurationClientBuilder();
    }

    protected AzureProperties getAzureProperties() {
        return this.configurationClientProperties;
    }

    protected List<AuthenticationDescriptor<?>> getAuthenticationDescriptors(ConfigurationClientBuilder builder) {
        AuthenticationDescriptor[] authenticationDescriptorArray = new AuthenticationDescriptor[1];
        authenticationDescriptorArray[0] = new TokenAuthenticationDescriptor(this.tokenCredentialResolver, arg_0 -> ((ConfigurationClientBuilder)builder).credential(arg_0));
        return Arrays.asList(authenticationDescriptorArray);
    }

    protected void configureService(ConfigurationClientBuilder builder) {
        PropertyMapper map = new PropertyMapper();
        map.from((Object)this.configurationClientProperties.getEndpoint()).to(arg_0 -> ((ConfigurationClientBuilder)builder).endpoint(arg_0));
        map.from((Object)this.configurationClientProperties.getServiceVersion()).to(arg_0 -> ((ConfigurationClientBuilder)builder).serviceVersion(arg_0));
    }

    protected BiConsumer<ConfigurationClientBuilder, Configuration> consumeConfiguration() {
        return ConfigurationClientBuilder::configuration;
    }

    protected BiConsumer<ConfigurationClientBuilder, TokenCredential> consumeDefaultTokenCredential() {
        return ConfigurationClientBuilder::credential;
    }

    protected BiConsumer<ConfigurationClientBuilder, String> consumeConnectionString() {
        return ConfigurationClientBuilder::connectionString;
    }

    protected BiConsumer<ConfigurationClientBuilder, RetryPolicy> consumeRetryPolicy() {
        return ConfigurationClientBuilder::retryPolicy;
    }
}

