/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.eventhubs.factory;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpTransportType;
import com.azure.core.amqp.ProxyOptions;
import com.azure.core.credential.TokenCredential;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.messaging.eventhubs.EventHubClientBuilder;
import com.azure.spring.cloud.core.implementation.credential.descriptor.AuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.NamedKeyAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.SasAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.TokenAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.factory.AbstractAzureAmqpClientBuilderFactory;
import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.service.implementation.eventhubs.properties.EventHubClientCommonProperties;
import com.azure.spring.cloud.service.implementation.eventhubs.properties.EventHubConsumerProperties;
import com.azure.spring.cloud.service.implementation.eventhubs.properties.EventHubsNamespaceProperties;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;

public class EventHubClientBuilderFactory
extends AbstractAzureAmqpClientBuilderFactory<EventHubClientBuilder> {
    private final EventHubClientCommonProperties eventHubsProperties;

    public EventHubClientBuilderFactory(EventHubClientCommonProperties eventHubsProperties) {
        this.eventHubsProperties = eventHubsProperties;
    }

    protected BiConsumer<EventHubClientBuilder, ProxyOptions> consumeProxyOptions() {
        return EventHubClientBuilder::proxyOptions;
    }

    protected BiConsumer<EventHubClientBuilder, AmqpTransportType> consumeAmqpTransportType() {
        return EventHubClientBuilder::transportType;
    }

    protected BiConsumer<EventHubClientBuilder, AmqpRetryOptions> consumeAmqpRetryOptions() {
        return EventHubClientBuilder::retryOptions;
    }

    protected BiConsumer<EventHubClientBuilder, ClientOptions> consumeClientOptions() {
        return EventHubClientBuilder::clientOptions;
    }

    protected BiConsumer<EventHubClientBuilder, Configuration> consumeConfiguration() {
        return EventHubClientBuilder::configuration;
    }

    protected BiConsumer<EventHubClientBuilder, TokenCredential> consumeDefaultTokenCredential() {
        return (builder, tokenCredential) -> builder.credential(this.eventHubsProperties.getFullyQualifiedNamespace(), this.eventHubsProperties.getEventHubName(), tokenCredential);
    }

    protected BiConsumer<EventHubClientBuilder, String> consumeConnectionString() {
        return (builder, connectionString) -> builder.connectionString(connectionString, this.eventHubsProperties.getEventHubName());
    }

    protected EventHubClientBuilder createBuilderInstance() {
        return new EventHubClientBuilder();
    }

    protected AzureProperties getAzureProperties() {
        return this.eventHubsProperties;
    }

    protected void configureService(EventHubClientBuilder builder) {
        PropertyMapper mapper = new PropertyMapper();
        mapper.from((Object)this.eventHubsProperties.getCustomEndpointAddress()).to(arg_0 -> ((EventHubClientBuilder)builder).customEndpointAddress(arg_0));
        if (this.eventHubsProperties instanceof EventHubsNamespaceProperties) {
            mapper.from((Object)((EventHubsNamespaceProperties)this.eventHubsProperties).getSharedConnection()).whenTrue().to(t -> builder.shareConnection());
        }
        if (this.eventHubsProperties instanceof EventHubConsumerProperties) {
            EventHubConsumerProperties consumerProperties = (EventHubConsumerProperties)this.eventHubsProperties;
            mapper.from((Object)consumerProperties.getConsumerGroup()).to(arg_0 -> ((EventHubClientBuilder)builder).consumerGroup(arg_0));
            mapper.from((Object)consumerProperties.getPrefetchCount()).to(arg_0 -> ((EventHubClientBuilder)builder).prefetchCount(arg_0));
        }
    }

    protected List<AuthenticationDescriptor<?>> getAuthenticationDescriptors(EventHubClientBuilder builder) {
        return Arrays.asList(new NamedKeyAuthenticationDescriptor(c -> builder.credential(this.eventHubsProperties.getFullyQualifiedNamespace(), this.eventHubsProperties.getEventHubName(), c)), new SasAuthenticationDescriptor(c -> builder.credential(this.eventHubsProperties.getFullyQualifiedNamespace(), this.eventHubsProperties.getEventHubName(), c)), new TokenAuthenticationDescriptor(this.tokenCredentialResolver, c -> builder.credential(this.eventHubsProperties.getFullyQualifiedNamespace(), this.eventHubsProperties.getEventHubName(), c)));
    }
}

