/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.cosmos;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.ProxyOptions;
import com.azure.core.util.Configuration;
import com.azure.cosmos.ConnectionMode;
import com.azure.cosmos.CosmosClientBuilder;
import com.azure.cosmos.DirectConnectionConfig;
import com.azure.cosmos.GatewayConnectionConfig;
import com.azure.spring.cloud.core.implementation.converter.AzureHttpProxyOptionsConverter;
import com.azure.spring.cloud.core.implementation.credential.descriptor.AuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.KeyAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.TokenAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.factory.AbstractAzureServiceClientBuilderFactory;
import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.core.provider.ProxyOptionsProvider;
import com.azure.spring.cloud.service.implementation.converter.DirectConnectionConfigConverter;
import com.azure.spring.cloud.service.implementation.converter.GatewayConnectionConfigConverter;
import com.azure.spring.cloud.service.implementation.cosmos.CosmosClientProperties;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosmosClientBuilderFactory
extends AbstractAzureServiceClientBuilderFactory<CosmosClientBuilder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CosmosClientBuilderFactory.class);
    private final CosmosClientProperties cosmosClientProperties;
    private ProxyOptions proxyOptions;

    public CosmosClientBuilderFactory(CosmosClientProperties cosmosClientProperties) {
        this.cosmosClientProperties = cosmosClientProperties;
    }

    protected CosmosClientBuilder createBuilderInstance() {
        return new CosmosClientBuilder();
    }

    protected AzureProperties getAzureProperties() {
        return this.cosmosClientProperties;
    }

    protected List<AuthenticationDescriptor<?>> getAuthenticationDescriptors(CosmosClientBuilder builder) {
        AuthenticationDescriptor[] authenticationDescriptorArray = new AuthenticationDescriptor[2];
        authenticationDescriptorArray[0] = new KeyAuthenticationDescriptor(arg_0 -> ((CosmosClientBuilder)builder).credential(arg_0));
        authenticationDescriptorArray[1] = new TokenAuthenticationDescriptor(this.tokenCredentialResolver, arg_0 -> ((CosmosClientBuilder)builder).credential(arg_0));
        return Arrays.asList(authenticationDescriptorArray);
    }

    protected void configureProxy(CosmosClientBuilder builder) {
        ProxyOptionsProvider.ProxyOptions proxy = this.cosmosClientProperties.getProxy();
        if (proxy instanceof ProxyOptionsProvider.HttpProxyOptions) {
            this.proxyOptions = AzureHttpProxyOptionsConverter.HTTP_PROXY_CONVERTER.convert((ProxyOptionsProvider.HttpProxyOptions)proxy);
            if (this.proxyOptions == null) {
                LOGGER.debug("No proxy properties available.");
            }
        } else {
            LOGGER.debug("The provided proxy options is not a ProxyOptionsProvider.HttpProxyOptions type.");
        }
    }

    protected void configureRetry(CosmosClientBuilder builder) {
        LOGGER.debug("CosmosClientBuilderFactory does not support common defined retry options");
    }

    protected void configureService(CosmosClientBuilder builder) {
        PropertyMapper map = new PropertyMapper();
        map.from((Object)this.cosmosClientProperties.getEndpoint()).to(arg_0 -> ((CosmosClientBuilder)builder).endpoint(arg_0));
        map.from((Object)this.cosmosClientProperties.getConsistencyLevel()).to(arg_0 -> ((CosmosClientBuilder)builder).consistencyLevel(arg_0));
        map.from((Object)this.cosmosClientProperties.getClientTelemetryEnabled()).to(arg_0 -> ((CosmosClientBuilder)builder).clientTelemetryEnabled(arg_0));
        map.from((Object)this.cosmosClientProperties.getConnectionSharingAcrossClientsEnabled()).to(arg_0 -> ((CosmosClientBuilder)builder).connectionSharingAcrossClientsEnabled(arg_0));
        map.from((Object)this.cosmosClientProperties.getContentResponseOnWriteEnabled()).to(arg_0 -> ((CosmosClientBuilder)builder).contentResponseOnWriteEnabled(arg_0));
        map.from((Object)this.cosmosClientProperties.getEndpointDiscoveryEnabled()).to(arg_0 -> ((CosmosClientBuilder)builder).endpointDiscoveryEnabled(arg_0));
        map.from((Object)this.cosmosClientProperties.getMultipleWriteRegionsEnabled()).to(arg_0 -> ((CosmosClientBuilder)builder).multipleWriteRegionsEnabled(arg_0));
        map.from((Object)this.cosmosClientProperties.getReadRequestsFallbackEnabled()).to(arg_0 -> ((CosmosClientBuilder)builder).readRequestsFallbackEnabled(arg_0));
        map.from((Object)this.cosmosClientProperties.getSessionCapturingOverrideEnabled()).to(arg_0 -> ((CosmosClientBuilder)builder).sessionCapturingOverrideEnabled(arg_0));
        map.from(this.cosmosClientProperties.getPreferredRegions()).whenNot(List::isEmpty).to(arg_0 -> ((CosmosClientBuilder)builder).preferredRegions(arg_0));
        map.from((Object)this.cosmosClientProperties.getThrottlingRetryOptions()).to(arg_0 -> ((CosmosClientBuilder)builder).throttlingRetryOptions(arg_0));
        this.configureConnection(builder, map);
    }

    private void configureConnection(CosmosClientBuilder builder, PropertyMapper map) {
        ConnectionMode connectionMode;
        map.from((Object)this.cosmosClientProperties.getResourceToken()).to(arg_0 -> ((CosmosClientBuilder)builder).resourceToken(arg_0));
        GatewayConnectionConfig gatewayConnectionConfig = GatewayConnectionConfigConverter.GATEWAY_CONNECTION_CONFIG_CONVERTER.convert(this.cosmosClientProperties.getGatewayConnection());
        if (this.proxyOptions != null) {
            gatewayConnectionConfig.setProxy(this.proxyOptions);
        }
        if (ConnectionMode.DIRECT.equals((Object)(connectionMode = this.cosmosClientProperties.getConnectionMode()))) {
            DirectConnectionConfig directConnectionConfig = DirectConnectionConfigConverter.DIRECT_CONNECTION_CONFIG_CONVERTER.convert(this.cosmosClientProperties.getDirectConnection());
            builder.directMode(directConnectionConfig, gatewayConnectionConfig);
        } else if (ConnectionMode.GATEWAY.equals((Object)connectionMode)) {
            builder.gatewayMode(gatewayConnectionConfig);
        }
    }

    protected BiConsumer<CosmosClientBuilder, String> consumeApplicationId() {
        return CosmosClientBuilder::userAgentSuffix;
    }

    protected BiConsumer<CosmosClientBuilder, Configuration> consumeConfiguration() {
        LOGGER.warn("Configuration instance is not supported to configure in CosmosClientBuilder");
        return (a, b) -> {};
    }

    protected BiConsumer<CosmosClientBuilder, TokenCredential> consumeDefaultTokenCredential() {
        return CosmosClientBuilder::credential;
    }

    protected BiConsumer<CosmosClientBuilder, String> consumeConnectionString() {
        LOGGER.debug("Connection string is not supported to configure in CosmosClientBuilder");
        return (a, b) -> {};
    }
}

