/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.feature.management.implementation;

import com.azure.spring.cloud.feature.management.models.TargetingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.springframework.util.StringUtils;

public class FeatureFilterUtils {
    public static void updateValueFromMapToList(Map<String, Object> parameters, String key) {
        FeatureFilterUtils.updateValueFromMapToList(parameters, key, false);
    }

    public static void updateValueFromMapToList(Map<String, Object> parameters, String key, boolean fixNull) {
        Object objectMap = parameters.get(key);
        if (objectMap instanceof Map) {
            Collection toType = ((Map)objectMap).values();
            parameters.put(key, toType);
        } else if (objectMap != null && objectMap.equals("") || objectMap == null && fixNull) {
            parameters.put(key, new ArrayList());
        } else if (objectMap != null) {
            parameters.put(key, objectMap);
        }
    }

    public static String getKeyCase(Map<String, Object> parameters, String key) {
        if (parameters != null && parameters.containsKey(key)) {
            return key;
        }
        return StringUtils.uncapitalize((String)key);
    }

    public static double isTargetedPercentage(String contextId) {
        byte[] hash = null;
        if (contextId == null) {
            contextId = "\n";
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            hash = digest.digest(contextId.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            throw new TargetingException("Unable to find SHA-256 for targeting.", e);
        }
        if (hash == null) {
            throw new TargetingException("Unable to create Targeting Hash for " + contextId);
        }
        BigInteger bi = FeatureFilterUtils.bigEndianToLittleEndian(hash);
        return (double)bi.longValue() / (Math.pow(2.0, 32.0) - 1.0) * 100.0;
    }

    public static BigInteger bigEndianToLittleEndian(byte[] bigEndian) {
        byte[] reversedBytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            reversedBytes[i] = bigEndian[3 - i];
        }
        return new BigInteger(1, reversedBytes);
    }
}

