/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.feature.management.telemetry;

import com.azure.spring.cloud.feature.management.models.EvaluationEvent;
import com.azure.spring.cloud.feature.management.models.Feature;
import com.azure.spring.cloud.feature.management.models.PercentileAllocation;
import com.azure.spring.cloud.feature.management.models.Variant;
import com.azure.spring.cloud.feature.management.models.VariantAssignmentReason;
import com.azure.spring.cloud.feature.management.telemetry.TelemetryPublisher;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LoggerTelemetryPublisher
implements TelemetryPublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggerTelemetryPublisher.class);

    @Override
    public void publishTelemetry(EvaluationEvent evaluationEvent) {
        if (evaluationEvent == null || evaluationEvent.getFeature() == null) {
            return;
        }
        Feature feature = evaluationEvent.getFeature();
        Variant variant = evaluationEvent.getVariant();
        HashMap<String, String> eventProperties = new HashMap<String, String>(Map.of("FeatureName", feature.getId(), "Enabled", String.valueOf(evaluationEvent.isEnabled()), "VariantAssignmentReason", evaluationEvent.getReason().getType(), "Version", "1.1.0"));
        if (variant != null) {
            eventProperties.put("Variant", variant.getName());
        }
        if (evaluationEvent.getReason() == VariantAssignmentReason.DEFAULT_WHEN_ENABLED) {
            eventProperties.put("VariantAssignmentPercentage", "100");
            if (feature.getAllocation() != null && feature.getAllocation().getPercentile() != null) {
                double allocationPercentage = 0.0;
                for (PercentileAllocation allocation2 : feature.getAllocation().getPercentile()) {
                    if (allocation2.getTo() == null || allocation2.getFrom() == null) continue;
                    allocationPercentage += allocation2.getTo() - allocation2.getFrom();
                }
                eventProperties.put("VariantAssignmentPercentage", String.valueOf(100.0 - allocationPercentage));
            }
        } else if (evaluationEvent.getReason() == VariantAssignmentReason.PERCENTILE && feature.getAllocation() != null && feature.getAllocation().getPercentile() != null) {
            eventProperties.put("VariantAssignmentPercentage", String.valueOf(feature.getAllocation().getPercentile().stream().filter(percentile -> percentile.getVariant() != null && variant != null && percentile.getVariant().equals(variant.getName())).filter(allocation -> allocation.getTo() != null && allocation.getFrom() != null).mapToDouble(allocation -> allocation.getTo() - allocation.getFrom()).sum()));
        }
        if (evaluationEvent.getFeature().getAllocation() != null && evaluationEvent.getFeature().getAllocation().getDefaultWhenEnabled() != null) {
            eventProperties.put("DefaultWhenEnabled", evaluationEvent.getFeature().getAllocation().getDefaultWhenEnabled());
        }
        for (Map.Entry entry : eventProperties.entrySet()) {
            MDC.put((String)((String)entry.getKey()), (String)((String)entry.getValue()));
        }
        MDC.put((String)"microsoft.custom_event.name", (String)"FeatureEvaluation");
        LOGGER.info("FeatureEvaluation");
        MDC.remove((String)"microsoft.custom_event.name");
        for (String key : eventProperties.keySet()) {
            MDC.remove((String)key);
        }
    }
}

