/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.feature.management.implementation;

import com.azure.spring.cloud.feature.management.models.Feature;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="feature-management")
public class FeatureManagementProperties {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @JsonProperty(value="feature-flags")
    private List<Feature> featureFlags;

    public List<Feature> getFeatureFlags() {
        return this.featureFlags;
    }

    public void setFeatureFlags(List<Feature> featureFlags) {
        if (featureFlags == null || featureFlags.isEmpty()) {
            System.out.println("No feature flags provided, setting empty list");
            this.featureFlags = List.of();
            return;
        }
        if (featureFlags.get(0) instanceof Feature) {
            ArrayList<Feature> features = new ArrayList<Feature>();
            for (Feature flag : featureFlags) {
                if (!(flag instanceof Feature)) continue;
                features.add(flag);
            }
            if (!features.isEmpty()) {
                this.featureFlags = features;
                return;
            }
        }
        ArrayList<Feature> convertedFlags = new ArrayList<Feature>();
        for (Feature feature : featureFlags) {
            Feature convertedFeature = (Feature)OBJECT_MAPPER.convertValue((Object)feature, Feature.class);
            convertedFlags.add(convertedFeature);
        }
        this.featureFlags = convertedFlags;
    }
}

