/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.feature.management.filters;

import com.azure.spring.cloud.feature.management.filters.ContextualFeatureFilter;
import com.azure.spring.cloud.feature.management.filters.FeatureFilter;
import com.azure.spring.cloud.feature.management.implementation.FeatureFilterUtils;
import com.azure.spring.cloud.feature.management.implementation.targeting.Audience;
import com.azure.spring.cloud.feature.management.implementation.targeting.GroupRollout;
import com.azure.spring.cloud.feature.management.models.FeatureFilterEvaluationContext;
import com.azure.spring.cloud.feature.management.models.TargetingException;
import com.azure.spring.cloud.feature.management.targeting.TargetingContext;
import com.azure.spring.cloud.feature.management.targeting.TargetingContextAccessor;
import com.azure.spring.cloud.feature.management.targeting.TargetingEvaluationOptions;
import com.azure.spring.cloud.feature.management.targeting.TargetingFilterContext;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class TargetingFilter
implements FeatureFilter,
ContextualFeatureFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TargetingFilter.class);
    protected static final String USERS = "Users";
    protected static final String GROUPS = "Groups";
    protected static final String AUDIENCE = "Audience";
    private static final String EXCLUSION_CAMEL = "Exclusion";
    protected static final String OUT_OF_RANGE = "The value is out of the accepted range.";
    private static final String REQUIRED_PARAMETER = "Value cannot be null.";
    protected static final ObjectMapper OBJECT_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).build();
    protected final TargetingContextAccessor contextAccessor;
    protected final TargetingEvaluationOptions options;

    public TargetingFilter(TargetingContextAccessor contextAccessor) {
        this.contextAccessor = contextAccessor;
        this.options = new TargetingEvaluationOptions();
    }

    public TargetingFilter(TargetingContextAccessor contextAccessor, TargetingEvaluationOptions options) {
        this.contextAccessor = contextAccessor;
        this.options = options;
    }

    @Override
    public boolean evaluate(FeatureFilterEvaluationContext context) {
        return this.evaluate(context, null);
    }

    @Override
    public boolean evaluate(FeatureFilterEvaluationContext context, Object appContext) {
        Audience audience;
        if (context == null) {
            throw new IllegalArgumentException("Targeting Context not configured.");
        }
        TargetingContext targetingContext = new TargetingFilterContext();
        if (appContext != null && appContext instanceof TargetingContext) {
            targetingContext = (TargetingContext)appContext;
        } else if (this.contextAccessor != null) {
            this.contextAccessor.configureTargetingContext(targetingContext);
        }
        if (this.validateTargetingContext(targetingContext)) {
            LOGGER.warn("No targeting context available for targeting evaluation.");
            return false;
        }
        Map parameters = context.getParameters();
        Object audienceObject = parameters.get(AUDIENCE);
        if (audienceObject != null) {
            parameters = (Map)audienceObject;
        }
        FeatureFilterUtils.updateValueFromMapToList(parameters, USERS, true);
        FeatureFilterUtils.updateValueFromMapToList(parameters, GROUPS, true);
        String exclusionValue = FeatureFilterUtils.getKeyCase(parameters, EXCLUSION_CAMEL);
        String exclusionUserValue = FeatureFilterUtils.getKeyCase((Map)parameters.get(exclusionValue), USERS);
        String exclusionGroupsValue = FeatureFilterUtils.getKeyCase((Map)parameters.get(exclusionValue), GROUPS);
        if (((Map)parameters.getOrDefault(exclusionValue, new HashMap())).get(exclusionUserValue) instanceof List) {
            audience = (Audience)OBJECT_MAPPER.convertValue((Object)parameters, Audience.class);
        } else {
            Object exclusionMap = (HashMap)parameters.remove(exclusionValue);
            if (exclusionMap == null) {
                exclusionMap = new HashMap();
            }
            Object users = exclusionMap.get(exclusionUserValue);
            Object groups = exclusionMap.get(exclusionGroupsValue);
            HashMap exclusion = new HashMap();
            if (users instanceof Map) {
                exclusion.put(USERS, new ArrayList(((Map)users).values()));
            }
            if (groups instanceof Map) {
                exclusion.put(GROUPS, new ArrayList(((Map)groups).values()));
            }
            parameters.put(exclusionValue, exclusion);
            audience = (Audience)OBJECT_MAPPER.convertValue((Object)parameters, Audience.class);
        }
        this.validateSettings(audience);
        if (this.targetUser(targetingContext.getUserId(), audience.getExclusion().getUsers())) {
            return false;
        }
        if (targetingContext.getGroups() != null && audience.getExclusion().getGroups() != null) {
            for (String group : targetingContext.getGroups()) {
                Optional<String> groupRollout = audience.getExclusion().getGroups().stream().filter(g -> this.equals((String)g, group)).findFirst();
                if (!groupRollout.isPresent()) continue;
                return false;
            }
        }
        if (this.targetUser(targetingContext.getUserId(), audience.getUsers())) {
            return true;
        }
        if (targetingContext.getGroups() != null && audience.getGroups() != null) {
            for (String group : targetingContext.getGroups()) {
                if (!this.targetGroup(audience, targetingContext, context, group)) continue;
                return true;
            }
        }
        String defaultContextId = targetingContext.getUserId() + "\n" + context.getFeatureName();
        return this.isTargeted(defaultContextId, audience.getDefaultRolloutPercentage());
    }

    private boolean targetUser(String userId, Collection<String> users) {
        return userId != null && users != null && users.stream().anyMatch(user -> this.equals(userId, (String)user));
    }

    private boolean targetGroup(Audience audience, TargetingContext targetingContext, FeatureFilterEvaluationContext context, String group) {
        Optional<GroupRollout> groupRollout = audience.getGroups().stream().filter(g -> this.equals(g.getName(), group)).findFirst();
        if (groupRollout.isPresent()) {
            String audienceContextId;
            String userId = "";
            if (targetingContext.getUserId() != null) {
                userId = targetingContext.getUserId();
            }
            if (this.isTargeted(audienceContextId = userId + "\n" + context.getFeatureName() + "\n" + group, groupRollout.get().getRolloutPercentage())) {
                return true;
            }
        }
        return false;
    }

    private boolean validateTargetingContext(TargetingContext targetingContext) {
        boolean hasUserDefined = StringUtils.hasText((String)targetingContext.getUserId());
        boolean hasGroupsDefined = targetingContext.getGroups() != null;
        boolean hasAtLeastOneGroup = false;
        if (hasGroupsDefined) {
            hasAtLeastOneGroup = targetingContext.getGroups().stream().anyMatch(group -> StringUtils.hasText((String)group));
        }
        return !hasUserDefined && (!hasGroupsDefined || !hasAtLeastOneGroup);
    }

    private boolean isTargeted(String contextId, double percentage) {
        return FeatureFilterUtils.isTargetedPercentage(contextId) < percentage;
    }

    void validateSettings(Audience audience) {
        Object paramName = "";
        String reason = "";
        if (audience == null) {
            paramName = AUDIENCE;
            reason = REQUIRED_PARAMETER;
            throw new TargetingException((String)paramName + " : " + reason);
        }
        if (audience.getDefaultRolloutPercentage() < 0.0 || audience.getDefaultRolloutPercentage() > 100.0) {
            paramName = "Audience." + audience.getDefaultRolloutPercentage();
            reason = OUT_OF_RANGE;
            throw new TargetingException((String)paramName + " : " + reason);
        }
        if (audience.getGroups() != null) {
            ArrayList<GroupRollout> groups = new ArrayList<GroupRollout>(audience.getGroups());
            for (int index = 0; index < groups.size(); ++index) {
                GroupRollout groupRollout = (GroupRollout)groups.get(index);
                if (!(groupRollout.getRolloutPercentage() < 0.0) && !(groupRollout.getRolloutPercentage() > 100.0)) continue;
                paramName = "Audience[" + index + "]." + ((GroupRollout)groups.get(index)).getRolloutPercentage();
                reason = OUT_OF_RANGE;
                throw new TargetingException((String)paramName + " : " + reason);
            }
        }
    }

    private boolean equals(String s1, String s2) {
        if (this.options.isIgnoreCase()) {
            return s1.equalsIgnoreCase(s2);
        }
        return s1.equals(s2);
    }
}

