/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.feature.management.implementation.timewindow.recurrence;

import com.azure.spring.cloud.feature.management.implementation.models.RecurrencePattern;
import com.azure.spring.cloud.feature.management.implementation.models.RecurrencePatternType;
import com.azure.spring.cloud.feature.management.implementation.models.RecurrenceRange;
import com.azure.spring.cloud.feature.management.implementation.models.RecurrenceRangeType;
import com.azure.spring.cloud.feature.management.implementation.timewindow.TimeWindowFilterSettings;
import com.azure.spring.cloud.feature.management.implementation.timewindow.TimeWindowUtils;
import com.azure.spring.cloud.feature.management.implementation.timewindow.recurrence.RecurrenceValidator;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;

public class RecurrenceEvaluator {
    public static boolean isMatch(TimeWindowFilterSettings settings, ZonedDateTime now) {
        RecurrenceValidator.validateSettings(settings);
        ZonedDateTime previousOccurrence = RecurrenceEvaluator.getPreviousOccurrence(settings, now);
        if (previousOccurrence == null) {
            return false;
        }
        ZonedDateTime occurrenceEndDate = previousOccurrence.plus(Duration.between(settings.getStart(), settings.getEnd()));
        return now.isBefore(occurrenceEndDate);
    }

    private static ZonedDateTime getPreviousOccurrence(TimeWindowFilterSettings settings, ZonedDateTime now) {
        ZonedDateTime start = settings.getStart();
        if (now.isBefore(start)) {
            return null;
        }
        RecurrencePatternType patternType = settings.getRecurrence().getPattern().getType();
        OccurrenceInfo occurrenceInfo = patternType == RecurrencePatternType.DAILY ? RecurrenceEvaluator.getDailyPreviousOccurrence(settings, now) : RecurrenceEvaluator.getWeeklyPreviousOccurrence(settings, now);
        RecurrenceRange range = settings.getRecurrence().getRange();
        RecurrenceRangeType rangeType = range.getType();
        if (rangeType == RecurrenceRangeType.ENDDATE && occurrenceInfo.previousOccurrence != null && occurrenceInfo.previousOccurrence.isAfter(range.getEndDate())) {
            return null;
        }
        if (rangeType == RecurrenceRangeType.NUMBERED && occurrenceInfo.numberOfOccurrences > range.getNumberOfOccurrences()) {
            return null;
        }
        return occurrenceInfo.previousOccurrence;
    }

    private static OccurrenceInfo getDailyPreviousOccurrence(TimeWindowFilterSettings settings, ZonedDateTime now) {
        ZonedDateTime start = settings.getStart();
        int interval = settings.getRecurrence().getPattern().getInterval();
        int numberOfOccurrences = (int)(Duration.between(start, now).getSeconds() / Duration.ofDays(interval).getSeconds());
        return new OccurrenceInfo(start.plusDays((long)numberOfOccurrences * (long)interval), numberOfOccurrences + 1);
    }

    private static OccurrenceInfo getWeeklyPreviousOccurrence(TimeWindowFilterSettings settings, ZonedDateTime now) {
        ZonedDateTime mostRecentOccurrence;
        RecurrencePattern pattern = settings.getRecurrence().getPattern();
        int interval = pattern.getInterval();
        ZonedDateTime start = settings.getStart();
        ZonedDateTime firstDayOfFirstWeek = start.minusDays(TimeWindowUtils.getPassedWeekDays(start.getDayOfWeek(), pattern.getFirstDayOfWeek()));
        long numberOfInterval = Duration.between(firstDayOfFirstWeek, now).toSeconds() / Duration.ofDays((long)interval * 7L).toSeconds();
        ZonedDateTime firstDayOfMostRecentOccurringWeek = firstDayOfFirstWeek.plusDays(numberOfInterval * (long)(interval * 7));
        List<DayOfWeek> sortedDaysOfWeek = TimeWindowUtils.sortDaysOfWeek(pattern.getDaysOfWeek(), pattern.getFirstDayOfWeek());
        int maxDayOffset = TimeWindowUtils.getPassedWeekDays(sortedDaysOfWeek.get(sortedDaysOfWeek.size() - 1), pattern.getFirstDayOfWeek());
        int minDayOffset = TimeWindowUtils.getPassedWeekDays(sortedDaysOfWeek.get(0), pattern.getFirstDayOfWeek());
        int numberOfOccurrences = (int)(numberOfInterval * (long)sortedDaysOfWeek.size() - (long)sortedDaysOfWeek.indexOf(start.getDayOfWeek()));
        if (now.isAfter(firstDayOfMostRecentOccurringWeek.plusDays(7L))) {
            ZonedDateTime mostRecentOccurrence2 = firstDayOfMostRecentOccurringWeek.plusDays(maxDayOffset);
            return new OccurrenceInfo(mostRecentOccurrence2, numberOfOccurrences += sortedDaysOfWeek.size());
        }
        ZonedDateTime dayWithMinOffset = firstDayOfMostRecentOccurringWeek.plusDays(minDayOffset);
        if (start.isAfter(dayWithMinOffset)) {
            numberOfOccurrences = 0;
            dayWithMinOffset = start;
        }
        if (now.isBefore(dayWithMinOffset)) {
            mostRecentOccurrence = firstDayOfMostRecentOccurringWeek.minusDays(interval * 7).plusDays(maxDayOffset);
        } else {
            mostRecentOccurrence = dayWithMinOffset;
            ++numberOfOccurrences;
            for (int i = sortedDaysOfWeek.indexOf(dayWithMinOffset.getDayOfWeek()) + 1; i < sortedDaysOfWeek.size() && !now.isBefore(dayWithMinOffset = firstDayOfMostRecentOccurringWeek.plusDays(TimeWindowUtils.getPassedWeekDays(sortedDaysOfWeek.get(i), pattern.getFirstDayOfWeek()))); ++i) {
                mostRecentOccurrence = dayWithMinOffset;
                ++numberOfOccurrences;
            }
        }
        return new OccurrenceInfo(mostRecentOccurrence, numberOfOccurrences);
    }

    private static class OccurrenceInfo {
        private final ZonedDateTime previousOccurrence;
        private final int numberOfOccurrences;

        OccurrenceInfo(ZonedDateTime dateTime, int num) {
            this.previousOccurrence = dateTime;
            this.numberOfOccurrences = num;
        }
    }
}

