/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.feature.management.implementation.timewindow.recurrence;

import com.azure.spring.cloud.feature.management.implementation.models.Recurrence;
import com.azure.spring.cloud.feature.management.implementation.models.RecurrencePattern;
import com.azure.spring.cloud.feature.management.implementation.models.RecurrencePatternType;
import com.azure.spring.cloud.feature.management.implementation.models.RecurrenceRangeType;
import com.azure.spring.cloud.feature.management.implementation.timewindow.TimeWindowFilterSettings;
import com.azure.spring.cloud.feature.management.implementation.timewindow.TimeWindowUtils;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;

public class RecurrenceValidator {
    public static void validateSettings(TimeWindowFilterSettings settings) {
        RecurrenceValidator.validateRecurrenceRequiredParameter(settings);
        RecurrenceValidator.validateRecurrencePattern(settings);
        RecurrenceValidator.validateRecurrenceRange(settings);
    }

    private static void validateRecurrenceRequiredParameter(TimeWindowFilterSettings settings) {
        Recurrence recurrence = settings.getRecurrence();
        String paramName = "";
        String reason = "";
        if (recurrence.getPattern() == null) {
            paramName = String.format("%s.%s", "Recurrence", "Pattern");
            reason = "Value cannot be null for required parameter: %s";
        }
        if (recurrence.getRange() == null) {
            paramName = String.format("%s.%s", "Recurrence", "Range");
            reason = "Value cannot be null for required parameter: %s";
        }
        if (!settings.getEnd().isAfter(settings.getStart())) {
            paramName = "End";
            reason = "The value of parameter %s is out of the accepted range.";
        }
        if (settings.getEnd().isAfter(settings.getStart().plusDays(3650L))) {
            paramName = "End";
            reason = "Time window duration cannot be longer than 10 years.";
        }
        if (!paramName.isEmpty()) {
            throw new IllegalArgumentException(String.format(reason, paramName));
        }
    }

    private static void validateRecurrencePattern(TimeWindowFilterSettings settings) {
        RecurrencePatternType patternType = settings.getRecurrence().getPattern().getType();
        if (patternType == RecurrencePatternType.DAILY) {
            RecurrenceValidator.validateDailyRecurrencePattern(settings);
        } else {
            RecurrenceValidator.validateWeeklyRecurrencePattern(settings);
        }
    }

    private static void validateRecurrenceRange(TimeWindowFilterSettings settings) {
        RecurrenceRangeType rangeType = settings.getRecurrence().getRange().getType();
        if (RecurrenceRangeType.ENDDATE.equals((Object)rangeType)) {
            RecurrenceValidator.validateEndDate(settings);
        }
    }

    private static void validateDailyRecurrencePattern(TimeWindowFilterSettings settings) {
        RecurrenceValidator.validateTimeWindowDuration(settings);
    }

    private static void validateWeeklyRecurrencePattern(TimeWindowFilterSettings settings) {
        RecurrenceValidator.validateDaysOfWeek(settings);
        RecurrencePattern pattern = settings.getRecurrence().getPattern();
        if (pattern.getDaysOfWeek().stream().noneMatch(dayOfWeekStr -> settings.getStart().getDayOfWeek() == dayOfWeekStr)) {
            throw new IllegalArgumentException(String.format("%s date is not a valid first occurrence.", "Start"));
        }
        RecurrenceValidator.validateTimeWindowDuration(settings);
        if (!RecurrenceValidator.isDurationCompliantWithDaysOfWeek(settings)) {
            throw new IllegalArgumentException(String.format("The time window between Start and End should be shorter than the minimum gap between %s", "Recurrence.Pattern.DaysOfWeek"));
        }
    }

    private static void validateTimeWindowDuration(TimeWindowFilterSettings settings) {
        RecurrencePattern pattern = settings.getRecurrence().getPattern();
        Duration intervalDuration = RecurrencePatternType.DAILY.equals((Object)pattern.getType()) ? Duration.ofDays(pattern.getInterval().intValue()) : Duration.ofDays((long)pattern.getInterval().intValue() * 7L);
        Duration timeWindowDuration = Duration.between(settings.getStart(), settings.getEnd());
        if (timeWindowDuration.compareTo(intervalDuration) > 0) {
            throw new IllegalArgumentException(String.format("The time window between Start and End should be shorter than the minimum gap between %s", "Recurrence.Pattern.Interval"));
        }
    }

    private static void validateDaysOfWeek(TimeWindowFilterSettings settings) {
        List<DayOfWeek> daysOfWeek = settings.getRecurrence().getPattern().getDaysOfWeek();
        if (daysOfWeek == null || daysOfWeek.size() == 0) {
            throw new IllegalArgumentException(String.format("Value cannot be null for required parameter: %s", "Recurrence.Pattern.DaysOfWeek"));
        }
    }

    private static void validateEndDate(TimeWindowFilterSettings settings) {
        if (settings.getRecurrence().getRange().getEndDate().isBefore(settings.getStart())) {
            throw new IllegalArgumentException("The Recurrence.Range.EndDate should be after the Start");
        }
    }

    private static boolean isDurationCompliantWithDaysOfWeek(TimeWindowFilterSettings settings) {
        Duration timeWindowDuration;
        Duration currentGap;
        ZonedDateTime date;
        List<DayOfWeek> daysOfWeek = settings.getRecurrence().getPattern().getDaysOfWeek();
        if (daysOfWeek.size() == 1) {
            return true;
        }
        ZonedDateTime today = ZonedDateTime.now();
        DayOfWeek firstDayOfWeek = settings.getRecurrence().getPattern().getFirstDayOfWeek();
        int offset = TimeWindowUtils.getPassedWeekDays(today.getDayOfWeek(), firstDayOfWeek);
        ZonedDateTime firstDateOfWeek = today.minusDays(offset).truncatedTo(ChronoUnit.DAYS);
        List<DayOfWeek> sortedDaysOfWeek = TimeWindowUtils.sortDaysOfWeek(daysOfWeek, firstDayOfWeek);
        ZonedDateTime prevOccurrence = null;
        Duration minGap = Duration.ofDays(7L);
        for (DayOfWeek day : sortedDaysOfWeek) {
            Duration currentGap2;
            date = firstDateOfWeek.plusDays(TimeWindowUtils.getPassedWeekDays(day, firstDayOfWeek));
            if (prevOccurrence != null && (currentGap2 = Duration.between(prevOccurrence, date)).compareTo(minGap) < 0) {
                minGap = currentGap2;
            }
            prevOccurrence = date;
        }
        if (settings.getRecurrence().getPattern().getInterval() == 1 && (currentGap = Duration.between(prevOccurrence, date = firstDateOfWeek.plusDays(7L).plusDays(TimeWindowUtils.getPassedWeekDays(sortedDaysOfWeek.get(0), firstDayOfWeek)))).compareTo(minGap) < 0) {
            minGap = currentGap;
        }
        return minGap.compareTo(timeWindowDuration = Duration.between(settings.getStart(), settings.getEnd())) >= 0;
    }
}

