/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.feature.management.implementation;

import com.azure.spring.cloud.feature.management.implementation.models.Feature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="feature-management")
public class FeatureManagementProperties
extends HashMap<String, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureManagementProperties.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.KEBAB_CASE);
    private static final long serialVersionUID = -1642032123104805346L;
    private transient Map<String, Feature> featureManagement = new HashMap<String, Feature>();
    private Map<String, Boolean> onOff = new HashMap<String, Boolean>();

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        if (m == null) {
            return;
        }
        this.featureManagement = new HashMap<String, Feature>();
        this.onOff = new HashMap<String, Boolean>();
        Map<? extends String, ? extends Object> features = this.removePrefixes(m, "featureManagement");
        if (!features.isEmpty()) {
            m = features;
        }
        for (String string : m.keySet()) {
            this.addToFeatures(m, string, "");
        }
    }

    private Map<? extends String, ? extends Object> removePrefixes(Map<? extends String, ? extends Object> m, String prefix) {
        Map removedPrefix = new HashMap();
        if (m.containsKey(prefix)) {
            removedPrefix = (Map)m.get(prefix);
        }
        return removedPrefix;
    }

    private void addToFeatures(Map<? extends String, ? extends Object> features, String key, String combined) {
        Object featureValue = features.get(key);
        if (!combined.isEmpty() && !combined.endsWith(".")) {
            combined = combined + ".";
        }
        if (featureValue instanceof Boolean) {
            this.onOff.put(combined + key, (Boolean)featureValue);
        } else {
            Feature feature = null;
            try {
                feature = (Feature)MAPPER.convertValue(featureValue, Feature.class);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Found invalid feature {} with value {}.", (Object)(combined + key), (Object)featureValue.toString());
            }
            if (feature != null && feature.getEnabledFor() == null && feature.getKey() == null) {
                if (Map.class.isAssignableFrom(featureValue.getClass())) {
                    features = (Map)featureValue;
                    for (String fKey : features.keySet()) {
                        this.addToFeatures(features, fKey, combined + key);
                    }
                }
            } else if (feature != null) {
                feature.setKey(key);
                this.featureManagement.put(key, feature);
            }
        }
    }

    public Map<String, Feature> getFeatureManagement() {
        return this.featureManagement;
    }

    public Map<String, Boolean> getOnOff() {
        return this.onOff;
    }
}

