/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.feature.management.filters;

import com.azure.spring.cloud.feature.management.filters.FeatureFilter;
import com.azure.spring.cloud.feature.management.models.FeatureFilterEvaluationContext;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class TimeWindowFilter
implements FeatureFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeWindowFilter.class);

    @Override
    public boolean evaluate(FeatureFilterEvaluationContext context) {
        String start = (String)context.getParameters().get("Start");
        String end = (String)context.getParameters().get("End");
        ZonedDateTime now = ZonedDateTime.now();
        if (!StringUtils.hasText((String)start) && !StringUtils.hasText((String)end)) {
            LOGGER.warn("The {} feature filter is not valid for feature {}. It must specify either {}, {}, or both.", new Object[]{this.getClass().getSimpleName(), context.getName(), "Start", "End"});
            return false;
        }
        ZonedDateTime startTime = null;
        ZonedDateTime endTime = null;
        try {
            startTime = StringUtils.hasText((String)start) ? ZonedDateTime.parse(start, DateTimeFormatter.ISO_DATE_TIME) : null;
            endTime = StringUtils.hasText((String)end) ? ZonedDateTime.parse(end, DateTimeFormatter.ISO_DATE_TIME) : null;
        }
        catch (DateTimeParseException e) {
            startTime = StringUtils.hasText((String)start) ? ZonedDateTime.parse(start, DateTimeFormatter.RFC_1123_DATE_TIME) : null;
            endTime = StringUtils.hasText((String)end) ? ZonedDateTime.parse(end, DateTimeFormatter.RFC_1123_DATE_TIME) : null;
        }
        return !(StringUtils.hasText((String)start) && !now.isAfter(startTime) || StringUtils.hasText((String)end) && !now.isBefore(endTime));
    }
}

