/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.feature.management.filters;

import com.azure.spring.cloud.feature.management.filters.FeatureFilter;
import com.azure.spring.cloud.feature.management.implementation.targeting.Audience;
import com.azure.spring.cloud.feature.management.implementation.targeting.Exclusion;
import com.azure.spring.cloud.feature.management.implementation.targeting.GroupRollout;
import com.azure.spring.cloud.feature.management.models.FeatureFilterEvaluationContext;
import com.azure.spring.cloud.feature.management.models.TargetingException;
import com.azure.spring.cloud.feature.management.targeting.TargetingContextAccessor;
import com.azure.spring.cloud.feature.management.targeting.TargetingEvaluationOptions;
import com.azure.spring.cloud.feature.management.targeting.TargetingFilterContext;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class TargetingFilter
implements FeatureFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TargetingFilter.class);
    protected static final String USERS = "users";
    protected static final String GROUPS = "groups";
    protected static final String AUDIENCE = "Audience";
    protected static final String EXCLUSION = "exclusion";
    private static final String EXCLUSION_CAMEL = "Exclusion";
    protected static final String OUT_OF_RANGE = "The value is out of the accepted range.";
    private static final String REQUIRED_PARAMETER = "Value cannot be null.";
    protected static final ObjectMapper OBJECT_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).build();
    protected final TargetingContextAccessor contextAccessor;
    protected final TargetingEvaluationOptions options;

    public TargetingFilter(TargetingContextAccessor contextAccessor) {
        this.contextAccessor = contextAccessor;
        this.options = new TargetingEvaluationOptions();
    }

    public TargetingFilter(TargetingContextAccessor contextAccessor, TargetingEvaluationOptions options) {
        this.contextAccessor = contextAccessor;
        this.options = options;
    }

    @Override
    public boolean evaluate(FeatureFilterEvaluationContext context) {
        Audience audience;
        if (context == null) {
            throw new IllegalArgumentException("Targeting Context not configured.");
        }
        TargetingFilterContext targetingContext = new TargetingFilterContext();
        this.contextAccessor.configureTargetingContext(targetingContext);
        if (this.validateTargetingContext(targetingContext)) {
            LOGGER.warn("No targeting context available for targeting evaluation.");
            return false;
        }
        Map parameters = context.getParameters();
        Object audienceObject = parameters.get(AUDIENCE);
        if (audienceObject != null) {
            parameters = (Map)audienceObject;
        }
        this.updateValueFromMapToList(parameters, USERS);
        this.updateValueFromMapToList(parameters, GROUPS);
        String exclusionValue = this.getKeyCase(parameters, EXCLUSION_CAMEL);
        String exclusionUserValue = this.getKeyCase((Map)parameters.get(exclusionValue), "Users");
        String exclusionGroupsValue = this.getKeyCase((Map)parameters.get(exclusionValue), "Groups");
        if (((Map)parameters.getOrDefault(exclusionValue, new HashMap())).get(exclusionUserValue) instanceof List) {
            audience = (Audience)OBJECT_MAPPER.convertValue((Object)parameters, Audience.class);
        } else {
            Object exclusionMap = (HashMap)parameters.remove(exclusionValue);
            if (exclusionMap == null) {
                exclusionMap = new HashMap();
            }
            audience = (Audience)OBJECT_MAPPER.convertValue((Object)parameters, Audience.class);
            Exclusion exclusion = new Exclusion();
            Object users = exclusionMap.get(exclusionUserValue);
            Object groups = exclusionMap.get(exclusionGroupsValue);
            if (users instanceof Map) {
                exclusion.setUsers(new ArrayList<String>(((Map)users).values()));
            }
            if (groups instanceof Map) {
                exclusion.setGroups(new ArrayList<String>(((Map)groups).values()));
            }
            audience.setExclusion(exclusion);
        }
        this.validateSettings(audience);
        if (this.targetUser(targetingContext.getUserId(), audience.getExclusion().getUsers())) {
            return false;
        }
        if (targetingContext.getGroups() != null && audience.getExclusion().getGroups() != null) {
            for (String group : targetingContext.getGroups()) {
                Optional<String> groupRollout = audience.getExclusion().getGroups().stream().filter(g -> this.equals((String)g, group)).findFirst();
                if (!groupRollout.isPresent()) continue;
                return false;
            }
        }
        if (this.targetUser(targetingContext.getUserId(), audience.getUsers())) {
            return true;
        }
        if (targetingContext.getGroups() != null && audience.getGroups() != null) {
            for (String group : targetingContext.getGroups()) {
                if (!this.targetGroup(audience, targetingContext, context, group)) continue;
                return true;
            }
        }
        String defaultContextId = targetingContext.getUserId() + "\n" + context.getFeatureName();
        return this.isTargeted(defaultContextId, audience.getDefaultRolloutPercentage());
    }

    private String getKeyCase(Map<String, Object> parameters, String key) {
        if (parameters != null && parameters.containsKey(key)) {
            return key;
        }
        return key.toLowerCase(Locale.getDefault());
    }

    private boolean targetUser(String userId, List<String> users) {
        return userId != null && users != null && users.stream().anyMatch(user -> this.equals(userId, (String)user));
    }

    private boolean targetGroup(Audience audience, TargetingFilterContext targetingContext, FeatureFilterEvaluationContext context, String group) {
        String audienceContextId;
        Optional<GroupRollout> groupRollout = audience.getGroups().stream().filter(g -> this.equals(g.getName(), group)).findFirst();
        return groupRollout.isPresent() && this.isTargeted(audienceContextId = targetingContext.getUserId() + "\n" + context.getName() + "\n" + group, groupRollout.get().getRolloutPercentage());
    }

    private boolean validateTargetingContext(TargetingFilterContext targetingContext) {
        boolean hasUserDefined = StringUtils.hasText((String)targetingContext.getUserId());
        boolean hasGroupsDefined = targetingContext.getGroups() != null;
        boolean hasAtLeastOneGroup = false;
        if (hasGroupsDefined) {
            hasAtLeastOneGroup = targetingContext.getGroups().stream().anyMatch(group -> StringUtils.hasText((String)group));
        }
        return !hasUserDefined && (!hasGroupsDefined || !hasAtLeastOneGroup);
    }

    protected double isTargetedPercentage(String contextId) {
        byte[] hash = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            hash = digest.digest(contextId.getBytes(Charset.defaultCharset()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new TargetingException("Unable to find SHA-256 for targeting.", e);
        }
        if (hash == null) {
            throw new TargetingException("Unable to create Targeting Hash for " + contextId);
        }
        ByteBuffer wrapped = ByteBuffer.wrap(hash);
        int contextMarker = Math.abs(wrapped.getInt());
        return (double)contextMarker / 2.147483647E9 * 100.0;
    }

    private boolean isTargeted(String contextId, double percentage) {
        return this.isTargetedPercentage(contextId) < percentage;
    }

    void validateSettings(Audience audience) {
        String paramName = "";
        String reason = "";
        if (audience == null) {
            paramName = AUDIENCE;
            reason = REQUIRED_PARAMETER;
            throw new TargetingException(paramName + " : " + reason);
        }
        if (audience.getDefaultRolloutPercentage() < 0.0 || audience.getDefaultRolloutPercentage() > 100.0) {
            paramName = "Audience." + audience.getDefaultRolloutPercentage();
            reason = OUT_OF_RANGE;
            throw new TargetingException(paramName + " : " + reason);
        }
        List<GroupRollout> groups = audience.getGroups();
        if (groups != null) {
            for (int index = 0; index < groups.size(); ++index) {
                GroupRollout groupRollout = groups.get(index);
                if (!(groupRollout.getRolloutPercentage() < 0.0) && !(groupRollout.getRolloutPercentage() > 100.0)) continue;
                paramName = "Audience[" + index + "]." + groups.get(index).getRolloutPercentage();
                reason = OUT_OF_RANGE;
                throw new TargetingException(paramName + " : " + reason);
            }
        }
    }

    private boolean equals(String s1, String s2) {
        if (this.options.isIgnoreCase()) {
            return s1.equalsIgnoreCase(s2);
        }
        return s1.equals(s2);
    }

    private void updateValueFromMapToList(Map<String, Object> parameters, String key) {
        Object objectMap = parameters.get(key);
        if (objectMap instanceof Map) {
            Collection toType = ((Map)objectMap).values();
            parameters.put(key, toType);
        }
    }
}

