/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.feature.management.web;

import com.azure.spring.cloud.feature.management.FeatureManager;
import com.azure.spring.cloud.feature.management.models.Variant;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import reactor.core.publisher.Mono;

public class FeatureManagerSnapshot {
    private final FeatureManager featureManager;
    private final Map<String, Boolean> requestMap;
    private final Map<String, Variant> variantMap;
    private static final Duration DEFAULT_BLOCK_TIMEOUT = Duration.ofSeconds(100L);

    FeatureManagerSnapshot(FeatureManager featureManager) {
        this.featureManager = featureManager;
        this.requestMap = new HashMap<String, Boolean>();
        this.variantMap = new HashMap<String, Variant>();
    }

    public Mono<Boolean> isEnabledAsync(String feature) {
        return this.isEnabledAsync(feature, null);
    }

    public Mono<Boolean> isEnabledAsync(String feature, Object featureContext) {
        Boolean featureValue = this.requestMap.get(feature);
        if (featureValue != null) {
            return Mono.just((Object)featureValue);
        }
        return this.featureManager.isEnabledAsync(feature, featureContext).doOnSuccess(enabled -> this.requestMap.put(feature, (Boolean)enabled));
    }

    public Boolean isEnabled(String feature) {
        return this.isEnabled(feature, null);
    }

    public Boolean isEnabled(String feature, Object featureContext) {
        return (Boolean)this.isEnabledAsync(feature, featureContext).block(DEFAULT_BLOCK_TIMEOUT);
    }

    public Mono<Variant> getVariantAsync(String feature) {
        return this.getVariantAsync(feature, null);
    }

    public Mono<Variant> getVariantAsync(String feature, Object featureContext) {
        Variant featureVariant = this.variantMap.get(feature);
        if (featureVariant != null) {
            return Mono.just((Object)featureVariant);
        }
        return this.featureManager.getVariantAsync(feature, featureContext).doOnSuccess(variant -> this.variantMap.put(feature, (Variant)variant));
    }

    public Variant getVariant(String feature) {
        return this.getVariant(feature, null);
    }

    public Variant getVariant(String feature, Object featureContext) {
        return (Variant)this.getVariantAsync(feature, featureContext).block(DEFAULT_BLOCK_TIMEOUT);
    }
}

