/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.docker.compose.implementation.service.connection.storage;

import com.azure.spring.cloud.autoconfigure.implementation.storage.queue.properties.AzureStorageQueueConnectionDetails;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;

class StorageQueueDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<AzureStorageQueueConnectionDetails> {
    private static final int STORAGE_QUEUE_PORT = 10001;

    protected StorageQueueDockerComposeConnectionDetailsFactory() {
        super("azure-storage/azurite", new String[0]);
    }

    protected AzureStorageQueueConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new StorageQueueContainerConnectionDetails(source.getRunningService());
    }

    private static class StorageQueueContainerConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements AzureStorageQueueConnectionDetails {
        private final String host;
        private final int port;

        StorageQueueContainerConnectionDetails(RunningService service) {
            super(service);
            this.host = service.host();
            this.port = service.ports().get(10001);
        }

        public String getConnectionString() {
            return "DefaultEndpointsProtocol=http;AccountName=devstoreaccount1;AccountKey=Eby8vdM02xNOcqFlqUwJPLlmEtlCDXJ1OUzFT50uSRZ6IFsuFq2UVErCz4I6tq/K1SZFPTOtr/KBHBeksoGMGw==;QueueEndpoint=http://%s:%d/devstoreaccount1;".formatted(this.host, this.port);
        }

        public String getEndpoint() {
            return "http://%s:%d".formatted(this.host, this.port);
        }
    }
}

