/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.implementation.properties;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.springframework.util.Assert;

public final class PropertyMapper {
    private static final String MSG_PREDICATE_CANNOT_BE_NULL = "Predicate must not be null";
    private final boolean alwaysApplyNonNull;

    public PropertyMapper() {
        this(true);
    }

    public PropertyMapper(boolean alwaysApplyNonNull) {
        this.alwaysApplyNonNull = alwaysApplyNonNull;
    }

    public <T> Source<T> from(Supplier<T> supplier) {
        Assert.notNull(supplier, (String)"Supplier must not be null");
        Source<Object> source = new Source<Object>(supplier, t -> true);
        if (this.alwaysApplyNonNull) {
            source = source.whenNonNull();
        }
        return source;
    }

    public <T> Source<T> from(T val) {
        return this.from((T)((Supplier<Object>)() -> val));
    }

    public static class Source<T> {
        private final Supplier<T> supplier;
        private final Predicate<T> predicate;

        Source(Supplier<T> supplier, Predicate<T> predicate) {
            Assert.notNull(predicate, (String)PropertyMapper.MSG_PREDICATE_CANNOT_BE_NULL);
            this.supplier = supplier;
            this.predicate = predicate;
        }

        public void to(Consumer<T> consumer) {
            T val = this.supplier.get();
            if (this.predicate.test(val)) {
                consumer.accept(val);
            }
        }

        public Source<T> when(Predicate<T> predicate) {
            Assert.notNull(predicate, (String)PropertyMapper.MSG_PREDICATE_CANNOT_BE_NULL);
            return new Source<T>(this.supplier, this.predicate.and(predicate));
        }

        public Source<T> whenNot(Predicate<T> predicate) {
            Assert.notNull(predicate, (String)PropertyMapper.MSG_PREDICATE_CANNOT_BE_NULL);
            return this.when(predicate.negate());
        }

        public Source<T> whenNonNull() {
            return new Source<Object>(new NullSafeSupplier<T>(this.supplier), Objects::nonNull);
        }

        public Source<T> whenTrue() {
            return this.when(Boolean.TRUE::equals);
        }

        public Source<T> whenFalse() {
            return this.when(Boolean.FALSE::equals);
        }
    }

    private static class NullSafeSupplier<T>
    implements Supplier<T> {
        private final Supplier<T> supplier;

        NullSafeSupplier(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        @Override
        public T get() {
            try {
                return this.supplier.get();
            }
            catch (NullPointerException ignored) {
                return null;
            }
        }
    }
}

