/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.implementation.credential.resolver;

import com.azure.core.credential.AzureNamedKeyCredential;
import com.azure.spring.cloud.core.credential.AzureCredentialResolver;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.core.properties.authentication.NamedKeyProperties;
import com.azure.spring.cloud.core.provider.authentication.NamedKeyProvider;
import org.springframework.util.StringUtils;

public final class AzureNamedKeyCredentialResolver
implements AzureCredentialResolver<AzureNamedKeyCredential> {
    @Override
    public AzureNamedKeyCredential resolve(AzureProperties properties) {
        if (!this.isResolvable(properties)) {
            return null;
        }
        NamedKeyProperties namedKey = ((NamedKeyProvider)((Object)properties)).getNamedKey();
        if (namedKey == null || !StringUtils.hasText((String)namedKey.getName()) || !StringUtils.hasText((String)namedKey.getKey())) {
            return null;
        }
        return new AzureNamedKeyCredential(namedKey.getName(), namedKey.getKey());
    }

    @Override
    public boolean isResolvable(AzureProperties properties) {
        return properties instanceof NamedKeyProvider;
    }
}

