/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.implementation.util;

import com.azure.spring.cloud.core.implementation.util.ClassUtils;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.core.provider.ClientOptionsProvider;
import com.azure.spring.cloud.core.provider.RetryOptionsProvider;
import java.beans.PropertyDescriptor;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.BiFunction;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;

public final class AzurePropertiesUtils {
    private AzurePropertiesUtils() {
    }

    public static <T extends AzureProperties> void copyAzureCommonProperties(AzureProperties source, T target) {
        BeanUtils.copyProperties((Object)source.getClient(), (Object)target.getClient());
        AzurePropertiesUtils.copyHttpClientProperties(source, target, false);
        BeanUtils.copyProperties((Object)source.getProxy(), (Object)target.getProxy());
        BeanUtils.copyProperties((Object)source.getProfile(), (Object)target.getProfile());
        BeanUtils.copyProperties((Object)source.getProfile().getEnvironment(), (Object)target.getProfile().getEnvironment());
        BeanUtils.copyProperties((Object)source.getCredential(), (Object)target.getCredential());
        if (source instanceof RetryOptionsProvider && target instanceof RetryOptionsProvider) {
            RetryOptionsProvider.RetryOptions sourceRetry = ((RetryOptionsProvider)((Object)source)).getRetry();
            RetryOptionsProvider.RetryOptions targetRetry = ((RetryOptionsProvider)((Object)target)).getRetry();
            BeanUtils.copyProperties((Object)sourceRetry, (Object)targetRetry);
            BeanUtils.copyProperties((Object)sourceRetry.getExponential(), (Object)targetRetry.getExponential());
            BeanUtils.copyProperties((Object)sourceRetry.getFixed(), (Object)targetRetry.getFixed());
        }
    }

    public static <T extends AzureProperties> void copyAzureCommonPropertiesIgnoreNull(AzureProperties source, T target) {
        AzurePropertiesUtils.copyPropertiesIgnoreNull(source.getClient(), target.getClient());
        AzurePropertiesUtils.copyHttpClientProperties(source, target, true);
        AzurePropertiesUtils.copyPropertiesIgnoreNull(source.getProxy(), target.getProxy());
        AzurePropertiesUtils.copyPropertiesIgnoreNull(source.getProfile(), target.getProfile());
        AzurePropertiesUtils.copyPropertiesIgnoreNull(source.getProfile().getEnvironment(), target.getProfile().getEnvironment());
        AzurePropertiesUtils.copyPropertiesIgnoreNull(source.getCredential(), target.getCredential());
        if (source instanceof RetryOptionsProvider && target instanceof RetryOptionsProvider) {
            RetryOptionsProvider.RetryOptions sourceRetry = ((RetryOptionsProvider)((Object)source)).getRetry();
            RetryOptionsProvider.RetryOptions targetRetry = ((RetryOptionsProvider)((Object)target)).getRetry();
            AzurePropertiesUtils.copyPropertiesIgnoreNull(sourceRetry, targetRetry);
            AzurePropertiesUtils.copyPropertiesIgnoreNull(sourceRetry.getExponential(), targetRetry.getExponential());
            AzurePropertiesUtils.copyPropertiesIgnoreNull(sourceRetry.getFixed(), targetRetry.getFixed());
        }
    }

    public static <T extends AzureProperties> void mergeAzureCommonProperties(AzureProperties defaultProperties, AzureProperties properties, T target) {
        AzurePropertiesUtils.copyAzureCommonProperties(defaultProperties, target);
        AzurePropertiesUtils.copyAzureCommonPropertiesIgnoreNull(properties, target);
    }

    public static void copyPropertiesIgnoreNull(Object source, Object target) {
        BeanUtils.copyProperties((Object)source, (Object)target, (String[])AzurePropertiesUtils.findNullPropertyNames(source));
    }

    public static void copyPropertiesIgnoreTargetNonNull(Object source, Object target) {
        BeanUtils.copyProperties((Object)source, (Object)target, (String[])AzurePropertiesUtils.findNonNullPropertyNames(target));
    }

    private static <T extends AzureProperties> void copyHttpClientProperties(AzureProperties source, T target, boolean ignoreNull) {
        if (source.getClient() instanceof ClientOptionsProvider.HttpClientOptions && target.getClient() instanceof ClientOptionsProvider.HttpClientOptions) {
            ClientOptionsProvider.HttpClientOptions sourceClient = (ClientOptionsProvider.HttpClientOptions)source.getClient();
            ClientOptionsProvider.HttpClientOptions targetClient = (ClientOptionsProvider.HttpClientOptions)target.getClient();
            if (ignoreNull) {
                AzurePropertiesUtils.copyPropertiesIgnoreNull(sourceClient.getLogging(), targetClient.getLogging());
            } else {
                BeanUtils.copyProperties((Object)sourceClient.getLogging(), (Object)targetClient.getLogging());
            }
            targetClient.getLogging().getAllowedHeaderNames().addAll(sourceClient.getLogging().getAllowedHeaderNames());
            targetClient.getLogging().getAllowedQueryParamNames().addAll(sourceClient.getLogging().getAllowedQueryParamNames());
            targetClient.getHeaders().addAll(sourceClient.getHeaders());
        }
    }

    private static String[] findPropertyNames(Object source, BiFunction<Class<?>, Object, Boolean> function) {
        PropertyDescriptor[] pds;
        HashSet<String> emptyNames = new HashSet<String>();
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(source);
        for (PropertyDescriptor pd : pds = beanWrapper.getPropertyDescriptors()) {
            Object srcValue = beanWrapper.getPropertyValue(pd.getName());
            if (!function.apply(pd.getPropertyType(), srcValue).booleanValue()) continue;
            emptyNames.add(pd.getName());
        }
        return emptyNames.toArray(new String[0]);
    }

    static String[] findNullPropertyNames(Object source) {
        return AzurePropertiesUtils.findPropertyNames(source, (propertyType, srcValue) -> Objects.isNull(srcValue) || ClassUtils.isPrimitiveDefaultValue(propertyType, srcValue));
    }

    static String[] findNonNullPropertyNames(Object source) {
        return AzurePropertiesUtils.findPropertyNames(source, (propertyType, srcValue) -> Objects.nonNull(srcValue) && ClassUtils.isPrimitiveNonDefaultValue(propertyType, srcValue));
    }
}

