/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.implementation.connectionstring;

import com.azure.spring.cloud.core.implementation.connectionstring.ConnectionStringType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;

class ConnectionString {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionString.class);
    private static final String TOKEN_VALUE_PAIR_DELIMITER = ";";
    private static final String TOKEN_VALUE_SEPARATOR = "=";
    private static final Map<ConnectionStringType, List<Set<String>>> TOKENS = ConnectionString.initTokensMap();
    private final String str;
    private final ConnectionStringType type;
    private URI endpoint = null;
    private final Map<String, String> segments = new HashMap<String, String>();

    ConnectionString(String str, @NonNull ConnectionStringType type) {
        this.str = str;
        this.type = type;
        this.resolveSegments();
    }

    private void resolveSegments() {
        if (!StringUtils.hasText((String)this.str)) {
            LOGGER.warn("'connectionString' doesn't have text.");
            return;
        }
        String[] tokenValuePairs = this.str.split(TOKEN_VALUE_PAIR_DELIMITER);
        this.validateTokenValuePresents(tokenValuePairs);
        this.validateTokensAreLegal(ConnectionString.collectTokens(tokenValuePairs));
        for (String tokenValuePair : tokenValuePairs) {
            String[] pair = tokenValuePair.split(TOKEN_VALUE_SEPARATOR, 2);
            String token = pair[0];
            String value = pair[1];
            if ("Endpoint".equalsIgnoreCase(token)) {
                try {
                    this.endpoint = new URI(value);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(String.format(Locale.US, "Invalid endpoint: %s", tokenValuePair), e);
                }
            }
            this.segments.put(token, value);
        }
    }

    public URI getEndpointUri() {
        return this.endpoint;
    }

    public String getSegment(String key) {
        return this.segments.get(key);
    }

    private static Map<ConnectionStringType, List<Set<String>>> initTokensMap() {
        EnumMap<ConnectionStringType, List<Set<String>>> tokensMap = new EnumMap<ConnectionStringType, List<Set<String>>>(ConnectionStringType.class);
        for (ConnectionStringType type : ConnectionStringType.values()) {
            ArrayList<Set<String>> tokensList = new ArrayList<Set<String>>();
            for (String schema : type.getSchemas()) {
                tokensList.add(ConnectionString.collectTokens(schema));
            }
            tokensMap.put(type, tokensList);
        }
        return tokensMap;
    }

    private void validateTokenValuePresents(String[] tokenValuePairs) {
        for (String tokenValuePair : tokenValuePairs) {
            String[] pair = tokenValuePair.split(TOKEN_VALUE_SEPARATOR, 2);
            if (pair.length == 2 && StringUtils.hasText((String)pair[1])) continue;
            throw new IllegalArgumentException(String.format(Locale.US, "Connection string has invalid key value pair: %s", tokenValuePair));
        }
    }

    private void validateTokensAreLegal(Set<String> tokens) {
        boolean isValid = false;
        ArrayList validTokensList = new ArrayList(TOKENS.get((Object)this.type));
        validTokensList.sort((a, b) -> Integer.compare(b.size(), a.size()));
        for (Set validTokens : validTokensList) {
            if (!tokens.containsAll(validTokens)) continue;
            isValid = true;
            break;
        }
        if (!isValid) {
            throw new IllegalArgumentException(String.format(Locale.US, "Connection string '%s' is invalid, valid schemas are %s", new Object[]{this.str, this.type}));
        }
    }

    private static Set<String> collectTokens(String str) {
        String[] tokenValuePairs = str.split(TOKEN_VALUE_PAIR_DELIMITER);
        return ConnectionString.collectTokens(tokenValuePairs);
    }

    private static Set<String> collectTokens(String[] tokenValuePairs) {
        return Arrays.stream(tokenValuePairs).map(a -> a.split(TOKEN_VALUE_SEPARATOR, 2)[0]).collect(Collectors.toSet());
    }
}

