/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.implementation.factory;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpTransportType;
import com.azure.core.amqp.ProxyOptions;
import com.azure.core.util.ClientOptions;
import com.azure.spring.cloud.core.implementation.converter.AzureAmqpProxyOptionsConverter;
import com.azure.spring.cloud.core.implementation.converter.AzureAmqpRetryOptionsConverter;
import com.azure.spring.cloud.core.implementation.factory.AbstractAzureServiceClientBuilderFactory;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.core.provider.ClientOptionsProvider;
import com.azure.spring.cloud.core.provider.ProxyOptionsProvider;
import com.azure.spring.cloud.core.provider.RetryOptionsProvider;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAzureAmqpClientBuilderFactory<T>
extends AbstractAzureServiceClientBuilderFactory<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAzureAmqpClientBuilderFactory.class);
    private ClientOptions clientOptions = new ClientOptions();

    protected abstract BiConsumer<T, ProxyOptions> consumeProxyOptions();

    protected abstract BiConsumer<T, AmqpTransportType> consumeAmqpTransportType();

    protected abstract BiConsumer<T, AmqpRetryOptions> consumeAmqpRetryOptions();

    protected abstract BiConsumer<T, ClientOptions> consumeClientOptions();

    @Override
    protected void configureCore(T builder) {
        super.configureCore(builder);
        this.configureAmqpClient(builder);
    }

    protected void configureAmqpClient(T builder) {
        this.configureClientProperties(builder);
        this.configureAmqpTransportProperties(builder);
    }

    protected void configureAmqpTransportProperties(T builder) {
        ClientOptionsProvider.AmqpClientOptions amqpClient;
        ClientOptionsProvider.ClientOptions client = this.getAzureProperties().getClient();
        if (client == null) {
            return;
        }
        if (client instanceof ClientOptionsProvider.AmqpClientOptions && (amqpClient = (ClientOptionsProvider.AmqpClientOptions)client).getTransportType() != null) {
            this.consumeAmqpTransportType().accept(builder, amqpClient.getTransportType());
        }
    }

    protected void configureClientProperties(T builder) {
        this.consumeClientOptions().accept(builder, this.clientOptions);
    }

    @Override
    protected BiConsumer<T, String> consumeApplicationId() {
        return (builder, id) -> this.clientOptions.setApplicationId(id);
    }

    @Override
    protected void configureRetry(T builder) {
        RetryOptionsProvider.RetryOptions retry = null;
        AzureProperties azureProperties = this.getAzureProperties();
        if (azureProperties instanceof RetryOptionsProvider) {
            retry = ((RetryOptionsProvider)((Object)azureProperties)).getRetry();
        }
        if (retry == null) {
            return;
        }
        if (retry instanceof RetryOptionsProvider.AmqpRetryOptions) {
            AmqpRetryOptions retryOptions = AzureAmqpRetryOptionsConverter.AMQP_RETRY_CONVERTER.convert((RetryOptionsProvider.AmqpRetryOptions)retry);
            if (retryOptions != null) {
                this.consumeAmqpRetryOptions().accept(builder, retryOptions);
            } else {
                LOGGER.debug("No AMQP retry properties available.");
            }
        } else {
            LOGGER.debug("The provided retry options is not a RetryOptionsProvider.AmqpRetryOptions type.");
        }
    }

    @Override
    protected void configureProxy(T builder) {
        ProxyOptionsProvider.ProxyOptions proxy = this.getAzureProperties().getProxy();
        if (proxy == null) {
            return;
        }
        if (proxy instanceof ProxyOptionsProvider.AmqpProxyOptions) {
            ProxyOptions proxyOptions = AzureAmqpProxyOptionsConverter.AMQP_PROXY_CONVERTER.convert((ProxyOptionsProvider.AmqpProxyOptions)proxy);
            if (proxyOptions != null) {
                this.consumeProxyOptions().accept(builder, proxyOptions);
            } else {
                LOGGER.debug("No AMQP proxy properties available.");
            }
        } else {
            LOGGER.debug("The provided proxy options is not a ProxyOptionsProvider.AmqpProxyOptions type.");
        }
    }

    protected ClientOptions getClientOptions() {
        return this.clientOptions;
    }

    public void setClientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }
}

